#include "choosePattern.h"
#include "led_patterns.h"
Serial pc1(USBTX, USBRX);    // Serial communication for debugging purposes

choosePattern::choosePattern()
{

    // Map the functions to the names
    m["SF"] = &flash; // slow flash
    m["FF"] = &flash; // flash flash
    m["FW"] = &wave; // forward wave
    m["BW"] = &backward_wave; // backward wave
    m["RF"] = &rise_and_fall; // rise and fall
    m["BF"] = &back_and_forth; // back and forth
}
choosePattern::~choosePattern()
{}

void choosePattern::find( std::string str, uint8_t r, uint8_t g, uint8_t b,  uint32_t delay, uint32_t duration)
{
    std::map<std::string, void (*) (uint8_t , uint8_t , uint8_t ,  uint32_t , uint32_t) >::const_iterator it;
    it = m.find(str);

    if(m.end() != it)
        it->second(r,g,b,delay,duration);
    else
        pc1.printf("Could not find the pattern \r\n");

}
