

void OneWireReset(void)   //Generates reset on 1-wire bus
{
    ibuttondata.output();
    ibuttondata = 0;
    wait_us(500);
    ibuttondata.input();
    wait_us(500);
}

void OneWireOutByte(unsigned char data)   //Write byte on 1-wire bus
{
    for (int n = 8; n!=0; n--) {
        if ((data & 0x01) == 1) {
            ibuttondata.output();
            ibuttondata = 0;
            wait_us(5);
            ibuttondata.input();
            wait_us(60);
        } else {
            ibuttondata.output();
            wait_us(60);
            ibuttondata.input();
        }
        data = data >> 1;
    }
}

unsigned char OneWireReadByte(void)   //Read 1 byte from 1-wire bus
{
    unsigned char d = 0;
    unsigned char b;
    for (int n = 0; n<8; n++) {
        ibuttondata.output();
        ibuttondata = 0;
        wait_us(5);
        ibuttondata.input();
        wait_us(5);
        b = ibuttondata;
        wait_us(50);
        d = (d >> 1) | (b << 7);
    }
    return d;
}

ibuttonvalue DetectiButton(void)   //Function to detect an iButton en give back its contents
{
    ibuttonvalue detect;
    unsigned char crc = 0;
    OneWireReset();
    OneWireOutByte(0x33); //Read Rom cmd
    detect.family = OneWireReadByte();
    crc = crc8(crc, detect.family);
    if (detect.family == 0x00 || detect.family == 0xFF) {
        detect.valid = 0;
        return detect; //No iButton detected
    }
    for (int i = 0; i <6; i++) {
        detect.serial[i] = OneWireReadByte();
        crc = crc8(crc, detect.serial[i]);
    }
    detect.crc = OneWireReadByte();
    if (crc == detect.crc) { //If CRC is valid: set valid flag to 1
        detect.valid = 1;
    }
    return detect;
}
void  lit_dallas(void)
{
    char low,high;
    for (int i = 0; i < 10; i++) recept[i]='x';
        //  lit_dallas();
        ibuttonvalue detected;
        detected = DetectiButton();
        if (detected.valid == 1) {
            for (int i = 0; i < 6; i++) {
                low=detected.serial[i];
                high=detected.serial[i];
                high=high & 0x0F;
                low=low>>4;
                low=low & 0x0f;
                low=low+0x30;
                high=high+0x30;
                if (low>58) low=low+10-3;
                if (high>58) high=high+10-3;
                recept[i*2]=low;
                recept[2*i+1]=high;
                pc.printf("%X",detected.serial[i]);
            }
        pc.printf("\n");
        recept[10]='\0';
        printf("Envoye au Client :%s",recept);
        printf("XEN");
            }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
  /*  ibuttonvalue detected;
    char low,high;
    detected = DetectiButton();
    printf("%d \n",DetectiButton());
    printf("valid %d \n",detected.valid);
    if (detected.valid == 1) { //Test valid flag
        pc.printf("detected.serial :");
        int j=0;
        for (int8_t i = 0; i < 6; i++) {
            low=detected.serial[i];
            high=detected.serial[i];
            high=high & 0x0F;
            low=low>>4;
            low=low & 0x0f;
            low=low+0x30;
            high=high+0x30;
            if (low>58) low=low+10-3;
            if (high>58) high=high+10-3;
            recept[i*2]=low;
            recept[2*i+1]=high;
            pc.printf("%X",detected.serial[i]);
        }
        pc.printf("\n");
        pc.printf("recompose.serial:");
        recept[9]='\n';
        recept[10]='\r';
        j=0;
        while(j!='\r') {
            pc.printf("%C",recept[j]);
            reponse_dallas[j]=recept[j];
            j++;
        }
        reponse_dallas[j]='\r';
        reponse_dallas[j+1]='\0';
        pc.printf("\n");
        //  pc.printf("%C",recept[j]);
        pc.printf("%S",reponse_dallas);
        //  pc.printf("%X",recept);
        pc.printf("\n");
        pc.printf("XXXX\n");
        for (int i = 0; i < 10; i++) envoi[i]=recept[i]; */
   
}

