#include "mbed.h"
#include "pwm_tone.h"

DigitalOut ledalim(p21);
DigitalOut led1(p22);
DigitalOut led2(p23);
DigitalOut led3(p24);
DigitalOut led4(p25);
PwmOut Buzzer(p26);
Ticker ledV;



float C_3 = 1000000/Do3,
      Cs_3 = 1000000/Do3s,
      D_3 = 1000000/Re3,
      Ds_3 = 1000000/Re3s,
      E_3 = 1000000/Mi3,
      F_3 = 1000000/Fa3,
      Fs_3 = 1000000/Fa3s,
      G_3 = 1000000/So3,
      Gs_3 = 1000000/So3s,
      A_3 = 1000000/La3,
      As_3 = 1000000/La3s,
      B_3 = 1000000/Ti3,
      C_4 = 1000000/Do4,
      Cs_4 = 1000000/Do4s,
      D_4 = 1000000/Re4,
      Ds_4 = 1000000/Re4s,
      E_4 = 1000000/Mi4,
      F_4 = 1000000/Fa4,
      Fs_4 = 1000000/Fa4s,
      G_4 = 1000000/So4,
      Gs_4 = 1000000/So4s,
      A_4 = 1000000/La4,
      As_4 = 1000000/La4s,
      B_4 = 1000000/Ti4,
      C_5 = 1000000/Do5,
      Cs_5 = 1000000/Do5s,
      D_5 = 1000000/Re5,
      Ds_5 = 1000000/Re5s,
      E_5 = 1000000/Mi5,
      F_5 = 1000000/Fa5,
      Fs_5 = 1000000/Fa5s,
      G_5 = 1000000/So5,
      Gs_5 = 1000000/So5s,
      A_5 = 1000000/La5,
      As_5 = 1000000/La5s,
      B_5 = 1000000/Ti5;

int tones[] = {E_5, D_5, C_5, D_5, E_5, E_5, E_5, 0, D_4, D_4, D_4, 0, E_4, G_4, G_4, 0,
               E_3, D_5, C_4, D_3, E_5, E_4, E_3, 0, D_4, D_4, E_4, D_4, C_4, 0, 0, 0, E_3, E_4, E_5, 0, 0, 0, 0, C_5, C_5, C_5, D_5, E_5, 0, D_5, 0, C_5, E_5, D_5, D_5, C_5, C_5, C_5, C_4, C_3, 0
              };
int tones_num = 65;

/* Private functions ---------------------------------------------------------*/
/**
   * @brief     Main Function
   * @param     None
   * @retval    None
   */

void ledverte()
{
    ledalim = !ledalim;  //Change l'état de la LED alim.
}


int main(void)
{

    ledalim = 1;    //led : ON
    wait(0.3);
    led1 = 1;       //led : ON
    wait(0.3);
    led2= 1;        //led : ON
    wait(0.3);
    led3= 1;        //led : ON          LED TICKER
    wait(0.3);
    led4 = 1;       //led : ON
    wait(0.3);
    ledalim = 0;    //led : OFF
    led1 = 0;       //led : OFF
    wait(0.3);
    led2= 0;        //led : OFF
    wait(0.3);
    led3= 0;        //led : OFF
    wait(0.3);
    led4 = 0;       //led : OFF
    wait(0.3);

    Tune(Buzzer, C_4, 4);  //4 Octave C beat 4/16
    wait_ms(250);
    Tune(Buzzer, D_4, 4);  //4 Octave D beat 4/16
    wait_ms(250);
    Tune(Buzzer, E_4, 4);  //4 Octave E beat 4/16
    wait_ms(250);

    int i;

    for(i=0; i<tones_num; i++) {
        Auto_tunes(Buzzer, tones[i], 4); // Auto performance
        Stop_tunes(Buzzer);
    
    }




}