#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include <string>
#include <vector>
#include <algorithm>


const char TURNON[]  = "ON";
const char TURNOFF[] = "OFF";

bool cmpStr(char* str1, const char* str2, int len)
{
     int k;
     for (k=0; k<len; k++){
         if (str1[k] != str2[k]) return false;
     }
     return true;    
}

DigitalOut Alarm(PB_0);

//defined for mDot SVB debug, comment it if applying for whole system
//#define NO_MULTITECH_GATEWAY

// these options must match the settings on your Conduit
// uncomment the following lines and edit their values to match your configuration
static std::string config_network_name = "chinaiot";
static std::string config_network_pass = "password";
static uint8_t config_frequency_sub_band = 2; 

int main() {
    int32_t ret; 
    mDot* dot;
    std::vector<uint8_t> sendData, recvData;
    std::vector<uint8_t> sendData1,sendData2, sendData3, sendData4;
    char recvBuf[11];
    int send_failed;
    int  i;
    //bool alarm_on;
    std::string data_str1 = "REQ1";
    std::string data_str2 = "REQ2";
    std::string data_str3 = "REQ3";
    std::string data_str4 = "REQ4";
    bool a1, a2, a3, a4;
    
 
    // get a mDot handle
    dot = mDot::getInstance();

    // print library version information
    logInfo("version: %s", dot->getId().c_str());

    //*******************************************
    // configuration
    //*******************************************
    // reset to default config so we know what state we're in
    dot->resetConfig();

    dot->setLogLevel(mts::MTSLog::INFO_LEVEL);

    // set up the mDot with our network information: frequency sub band, network name, and network password
    // these can all be saved in NVM so they don't need to be set every time - see mDot::saveConfig()

    // frequency sub band is only applicable in the 915 (US) frequency band
    // if using a MultiTech Conduit gateway, use the same sub band as your Conduit (1-8) - the mDot will use the 8 channels in that sub band
    // if using a gateway that supports all 64 channels, use sub band 0 - the mDot will use all 64 channels
    logInfo("setting frequency sub band");
    if ((ret = dot->setFrequencySubBand(config_frequency_sub_band)) != mDot::MDOT_OK) {
        logError("failed to set frequency sub band %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    logInfo("setting network name");
    if ((ret = dot->setNetworkName(config_network_name)) != mDot::MDOT_OK) {
        logError("failed to set network name %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    logInfo("setting network password");
    if ((ret = dot->setNetworkPassphrase(config_network_pass)) != mDot::MDOT_OK) {
        logError("failed to set network password %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    // a higher spreading factor allows for longer range but lower throughput
    // in the 915 (US) frequency band, spreading factors 7 - 10 are available
    // in the 868 (EU) frequency band, spreading factors 7 - 12 are available
    logInfo("setting TX spreading factor");
    if ((ret = dot->setTxDataRate(mDot::SF_10)) != mDot::MDOT_OK) {
        logError("failed to set TX datarate %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    // request receive confirmation of packets from the gateway
    logInfo("enabling ACKs");
    if ((ret = dot->setAck(1)) != mDot::MDOT_OK) {
        logError("failed to enable ACKs %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    // save this configuration to the mDot's NVM
    logInfo("saving config");
    if (! dot->saveConfig()) {
        logError("failed to save configuration");
    }
    //*******************************************
    // end of configuration
    //*******************************************

    // attempt to join the network
    logInfo("joining network");
    while ((ret = dot->joinNetwork()) != mDot::MDOT_OK) {
        logError("failed to join network %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
        // in the 868 (EU) frequency band, we need to wait until another channel is available before transmitting again
        osDelay(std::max((uint32_t)1000, (uint32_t)dot->getNextTxMs()));
    }
   
    // format data for sending to the gateway
    for (std::string::iterator it = data_str1.begin(); it != data_str1.end(); it++)
        sendData1.push_back((uint8_t) *it);
    
    // format data for sending to the gateway
    for (std::string::iterator it = data_str2.begin(); it != data_str2.end(); it++)
        sendData2.push_back((uint8_t) *it);
        
    // format data for sending to the gateway
    for (std::string::iterator it = data_str3.begin(); it != data_str3.end(); it++)
        sendData3.push_back((uint8_t) *it);

    // format data for sending to the gateway
    for (std::string::iterator it = data_str4.begin(); it != data_str4.end(); it++)
        sendData4.push_back((uint8_t) *it);
        
    send_failed = 0;              
    while (true) {         
            // send the data to the gateway
            if ((ret = dot->send(sendData1)) != mDot::MDOT_OK) {
               send_failed++; 
               logError("failed to send", ret, mDot::getReturnCodeString(ret).c_str());
               osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
            } else { 
                send_failed=0;            
                logInfo("successfully sent data to gateway");  
                for(i=0;i<11;i++)recvBuf[i]=0; //clear recv buffer
                recvData.clear(); //clear recv data
                if ((ret = dot->recv(recvData)) != mDot::MDOT_OK) {
                   logError("failed to recv: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
                } else {
                   //logInfo("datasize = %d", recvData.size());
                   for(i=0; i< recvData.size(); i++ )
                     recvBuf[i] = recvData[i];
                   //logInfo("RECV:%s", recvBuf);
                   if(cmpStr(recvBuf, TURNON, 2)){
                      a1 = true;
                      logInfo("A1 is on!"); 
                    } 
                    if(cmpStr(recvBuf, TURNOFF, 3)){
                      a1 = false;
                      logInfo("A1 is off!"); 
                    }    
                } 
            }
            
            osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));

            // send the data to the gateway
            if ((ret = dot->send(sendData2)) != mDot::MDOT_OK) {
               send_failed++; 
               logError("failed to send", ret, mDot::getReturnCodeString(ret).c_str());
               osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
            } else { 
                send_failed=0;            
                logInfo("successfully sent data to gateway");  
                for(i=0;i<11;i++)recvBuf[i]=0; //clear recv buffer
                recvData.clear(); //clear recv data
                if ((ret = dot->recv(recvData)) != mDot::MDOT_OK) {
                   logError("failed to recv: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
                } else {
                   //logInfo("datasize = %d", recvData.size());
                   for(i=0; i< recvData.size(); i++ )
                     recvBuf[i] = recvData[i];
                   //logInfo("RECV:%s", recvBuf);
                   if(cmpStr(recvBuf, TURNON, 2)){
                      a2 = true;
                      logInfo("A2 is on!"); 
                    } 
                    if(cmpStr(recvBuf, TURNOFF, 3)){
                      a2 = false;
                      logInfo("A2 is off!"); 
                    }    
                } 
            }
            
            osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));

            // send the data to the gateway
            if ((ret = dot->send(sendData3)) != mDot::MDOT_OK) {
               send_failed++; 
               logError("failed to send", ret, mDot::getReturnCodeString(ret).c_str());
               osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
            } else { 
                send_failed=0;            
                logInfo("successfully sent data to gateway");  
                for(i=0;i<11;i++)recvBuf[i]=0; //clear recv buffer
                recvData.clear(); //clear recv data
                if ((ret = dot->recv(recvData)) != mDot::MDOT_OK) {
                   logError("failed to recv: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
                } else {
                   //logInfo("datasize = %d", recvData.size());
                   for(i=0; i< recvData.size(); i++ )
                     recvBuf[i] = recvData[i];
                   //logInfo("RECV:%s", recvBuf);
                   if(cmpStr(recvBuf, TURNON, 2)){
                      a3 = true;
                      logInfo("A3 is on!"); 
                    } 
                    if(cmpStr(recvBuf, TURNOFF, 3)){
                      a3 = false;
                      logInfo("A3 is off!"); 
                    }    
                } 
            }
            
            osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
            
            // send the data to the gateway
            if ((ret = dot->send(sendData4)) != mDot::MDOT_OK) {
               send_failed++; 
               logError("failed to send", ret, mDot::getReturnCodeString(ret).c_str());
               osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
            } else { 
                send_failed=0;            
                logInfo("successfully sent data to gateway");  
                for(i=0;i<11;i++)recvBuf[i]=0; //clear recv buffer
                recvData.clear(); //clear recv data
                if ((ret = dot->recv(recvData)) != mDot::MDOT_OK) {
                   logError("failed to recv: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
                } else {
                   //logInfo("datasize = %d", recvData.size());
                   for(i=0; i< recvData.size(); i++ )
                     recvBuf[i] = recvData[i];
                   //logInfo("RECV:%s", recvBuf);
                   if(cmpStr(recvBuf, TURNON, 2)){
                      a4 = true;
                      logInfo("A4 is on!"); 
                    } 
                    if(cmpStr(recvBuf, TURNOFF, 3)){
                      a4 = false;
                      logInfo("A4 is off!"); 
                    }    
                } 
            }
            osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
            
            if(a1 || a2 || a3 || a4){
                logInfo("============================");
                logInfo("Alarm is ON");
                Alarm = 1;
            }else{
                logInfo("============================");
                logInfo("Alarm is OFF");
                Alarm = 0;
            }
            
            osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
                         
        
        if(send_failed>=3){
           send_failed=0;           
           // attempt to rejoin the network
           logInfo("Attemp to rejoin network....");
           if ((ret = dot->joinNetworkOnce()) != mDot::MDOT_OK) {
                logError("Failed to rejoin network!"); // %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
           }else{
                logInfo("Rejoin network successfully!");   
           } 
           osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
        }
        
    }

}
