#include "mbed.h"
#include "DataLoggerRS232.h"
#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include <string>
#include <vector>
#include <algorithm>
#include <math.h>

//define baudrate
#define PC_BAUDRATE            115200
#define CARD_MACHINE_BAUDRATE  19200

Serial pc       (USBTX, USBRX);  // tx, rx
Serial cm_rs485 (PA_2,PA_3);  // tx, rx

#define COMMAND_LENGTH   7
#define RESPONSE_LENGTH  16

//#define RINGBUFFER_SIZE  100

//unsigned int inIndex  = 0;
//unsigned int outIndex = 0;

//char ringBuffer[RINGBUFFER_SIZE][RESPONSE_LENGTH] = {0};

//char DLcommand; to be translated into hex for reading of total power
char readCmd[COMMAND_LENGTH] = {0x09,0x41,0x31,0x46,0x33,0x46,0x0d};
char readBuf[RESPONSE_LENGTH] = {0};

int main() 
{    
    char chr, chr0, chr1, chr2;
    int i;
    mDot* dot;
        
    // get a mDot handle
    //dot = mDot::getInstance();

    // print library version information
    //logInfo("version: %s", dot->getId().c_str());

    //*******************************************
    // configuration
    //*******************************************
    // reset to default config so we know what state we're in
    //dot->resetConfig();
    
    //set baudrate
    //dot->setBaud(BAUDRATE);
    //dot->setLogLevel(mts::MTSLog::INFO_LEVEL);
    // set up the mDot with our network information: frequency sub band, network name, and network password
    // these can all be saved in NVM so they don't need to be set every time - see mDot::saveConfig()

    //logInfo("Baudrate is: %d", dot->getBaud());
    // frequency sub band is only applicable in the 915 (US) frequency band
    // if using a MultiTech Conduit gateway, use the same sub band as your Conduit (1-8) - the mDot will use the 8 channels in that sub band
    // if using a gateway that supports all 64 channels, use sub band 0 - the mDot will use all 64 channels
    //logInfo("setting frequency sub band");
    
    pc.baud(PC_BAUDRATE);
    pc.printf("PC COM RS232 baudrate: %d \n\r", PC_BAUDRATE);
    cm_rs485.baud(CARD_MACHINE_BAUDRATE);
    cm_rs485.format(9,SerialBase::Even,1);
    //cm_rs485.attach(&txIsr, SerialBase::TxIrq);
    //cm_rs485.attach(&rxIsr, SerialBase::RxIrq);
    pc.printf("Card Machine RS485 baudrate: %d!\n\r", CARD_MACHINE_BAUDRATE);

    while(1) {
        
        /* clear the read buffer */
        for(i=0;i<RESPONSE_LENGTH;i++){
            readBuf[i]=0;
        }
        
        pc.printf("Send the READ command!\n\r"); //, &readCmd[1]);
        if(cm_rs485.writeable()){
            for(i=0;i<COMMAND_LENGTH;i++){
               cm_rs485.putc(readCmd[i]);
            }            
        }
        
        i=0;
        
        chr = cm_rs485.getc();
        while(chr != 0x0d)
        {
            readBuf[i] = chr;
            chr = cm_rs485.getc();
            i++;
        }
        
        pc.printf("Response[ASCII]:");
        for(i=0; i< RESPONSE_LENGTH; i++){
           pc.printf("%0X ", readBuf[i]);
           if (readBuf[i] == 0) break;
        } 
        pc.printf("Response[Text]:%s\n\r", &readBuf[3]);
        
        wait(1);          
    }
}
