#include "mbed.h"
#include "DataLoggerRS232.h"


DataLoggerRS232::DataLoggerRS232(PinName tx, PinName rx, const char* name) : Serial(tx, rx, name) {
    printf("Here!! \r\n");
    // set up ring buffer
    ringBuffer = new char[65536];
    // pointer to first sample 
    rHead = ringBuffer;
    // pointer to indicate position in the Ring Buffer
    rPos = ringBuffer;
    // pointer to indicate display position in the Ring Buffer
    rDisplay = ringBuffer;
    
    printf("DataLogger_RS232 Ring Buffer setup complete!\r\n");
}

void DataLoggerRS232::get_ECU_databyte() {
        
        while(Serial::readable()) {
            
            MSserial = Serial::getc();
                // save the sample into ring buffer
                if( rPos == &ringBuffer[65535] )
                rPos = ringBuffer;
                else 
                rPos++;
            
            *rPos = MSserial;
            
            count++;
        }
        printf("get_ECU_databyte !!\r\n");
}

void DataLoggerRS232::display_ECU_databyte() {
        
        while (rDisplay != rPos) {
            printf("%d, %X\n\r",count,rDisplay);
            if( rDisplay == &ringBuffer[65535] )
                rDisplay = ringBuffer;
                else 
                rDisplay++;   
        }
        //printf("display_ECU_databyte !!\r\n");


}


DataLoggerRS232::~DataLoggerRS232() {
}