/* Copyright (c) <2012> <P. Patel>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
// --------------------- Median Filtered Linear Temperature Sensor Reader ----------------------------
 
#include "LinearTemp.h"
#include "mbed.h"

// Constructor using two calibration points to define linear multiplier and offset
LinearTemp::LinearTemp(PinName pin, float temp1, unsigned short read1, float temp2, unsigned short read2):_pin(pin) {
    _temp = 0.0;                                     // Zero the temperature
    _multiplier = (temp2 - temp1) / (read2 - read1); // Calculate multiplier as slope
    _offset = temp1 - (_multiplier * read1);         // Calculate offset
}

// Constructor using user defined multiplier and offset
LinearTemp::LinearTemp(PinName pin, float multiplier, float offset):_pin(pin) {
    _temp = 0.0;                                     // Zero the temperature
    _multiplier = multiplier;                        // Set multiplier
    _offset = offset;                                // Set offset
}

// Populates an array with temperature readings, sorts, and returns median
float LinearTemp::readTemp() {
   /*
    _tempArr[0] = _pin.read_u16();
    for (int i = 1; i < 9; i++) { 
        _tempArr[i] = _pin.read_u16();
        unsigned short tmp = _tempArr[i];
        int j;            
        for (j = i - 1; j >= 0; j--) {
            if (tmp>=_tempArr[j]) break;
            _tempArr[j + 1] = _tempArr[j];
        }
        _tempArr[j + 1] = tmp;
    }
    //_temp = (_tempArr[4] * _multiplier) + _offset;
    */
    _temp = (float)_pin.read_u16();
    _temp = _temp*3/(16*4096);
    return _temp;
}
// Returns last calculated temperature value
float LinearTemp::getTemp() {
    return _temp;
}