/* Copyright (c) <2012> <P. Patel>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
// --------------------- Median Filtered Linear Temperature Sensor Reader ----------------------------
 
#include "AnalogPH.h"
#include "mbed.h"
#include "mDot.h"

// Constructor using two calibration points to define linear multiplier and offset
AnalogPHSensor::AnalogPHSensor(PinName pin, float temp1, unsigned short read1, float temp2, unsigned short read2):_pin(pin) {
    _ph = 0.0;                                     // Zero the temperature
    _multiplier = (temp2 - temp1) / (read2 - read1); // Calculate multiplier as slope
    _offset = temp1 - (_multiplier * read1);         // Calculate offset
}
// Constructor using user defined multiplier and offset
AnalogPHSensor::AnalogPHSensor(PinName pin, float multiplier, float offset):_pin(pin) {
    _ph = 0.0;                                     // Zero the temperature
    _multiplier = multiplier;                        // Set multiplier
    _offset = offset;                                // Set offset
}

// Populates an array with ph readings, sorts, and returns median
float AnalogPHSensor::readPH() {
    unsigned short i, minValue, maxValue;
    
    _ph = 0.0;
    for (i = 0; i < 6; i++) { 
        _phArr[i] = _pin.read_u16();
        osDelay(100);
    }
    
        //looking for the minValue and maxValue in the buffer
    minValue = _phArr[0];
    maxValue = _phArr[0];
    for(i=1; i<6; i++){
        if(minValue > _phArr[i])minValue=_phArr[i];
        if(maxValue < _phArr[i])maxValue=_phArr[i];
    } 
    
        //sum
    for(i=0; i<6; i++)
    {
         _ph += (float)_phArr[i];
    }
    
    // minus max and min
    _ph -= (float)minValue;
    _ph -= (float)maxValue;
    
    //averaging
    _ph = _ph/4.0;
    
    _ph = 3.0*_ph/(16.0*4096);
    return _ph;
}
// Returns last calculated ph value
float AnalogPHSensor::getPH() {
    return _ph;
}