/**
 * @author Jose L. Escalona (virtualmech)
 */

#ifndef BMA180_H
#define BMA180_H
 
#include "mbed.h"

#define BMA180_ID       0x00
#define VERSION         0x01
#define ACCXLSB         0x02
#define ACCXMSB         0x03
#define ACCYLSB         0x04
#define ACCYMSB         0x05
#define ACCZLSB         0x06
#define ACCZMSB         0x07
#define CTRL_REG0       0x0D
#define DIS_I2C         0x27    // bit 0 must be 1 for SPI
#define CTRL_REG3       0x21    // bit 1= new_data_int
#define RESET           0x10    // soft reset

#define RANGE           0x35
#define FILTER_BW       0x20
#define NOISE_POWER     0x30

/*-------------Hardware connections-------------
VIO----- mbed Vout (3.3 Volt)
SDI----- mbed mosi (p5)
SDO----- mbed miso (p6)
SCK----- mbed sck  (p7)
CS------ mbed (p8)          // chip select
(Interrupts not used)   INT----- mbed (p9)          // MBA give a interrupt when ready
GND----- mbed GND (0 Volt)
VDO----- mbed Vout (3.3 Volt)
there are no additional external components used
//----------------------------------------------*/

/**
 * BMA180 triple axis, digital interface, accelerometer.
 */
class BMA180 {

public:
    /**
     * Constructor.
     *
     * @param mosi mbed pin to use for MOSI line of SPI interface.
     * @param miso mbed pin to use for MISO line of SPI interface.
     * @param sck mbed pin to use for SCK line of SPI interface.
     * @param cs mbed pin to use for not chip select line of SPI interface.
     */
    BMA180(PinName mosi, PinName miso, PinName sck, PinName cs);
    
    void soft_reset(void);

    void new_data(void);
    void write_bits(char u);
    void write_reg(uint8_t address, char data);
    char read_reg(uint8_t address);
    void disable_int(void);

    void ReadAccels_BMA180(int*);
    
    //OJO, NO ESTOY SEGURO DE QUE ESTA FUNCION ESTÉ BIEN IMPLEMENTADA
    void AcelerometroSleep(void);                    //Pone el acelerometro en sleep mode para no consumir energía
    //OJO, NO ESTOY SEGURO DE QUE ESTA FUNCION ESTÉ BIEN IMPLEMENTADA
    void AcelerometroWakeUp(void);                   //Pone el acelerometro preparado para medir
    void AcelerometroLeeOffsets(int *);              //Lee los valores de los 3 offsets: x, y, z 
    void AcelerometroEscribeOffsets(char *);         //Escribe los valores de los 3 offsets: x, y, z  
    
    private:

    SPI        spi_;
    DigitalOut nCS_;

};

#endif /* BMA180_H */