/**
 * @author Jose L. Escalona (virtualmech)
 */

#include "BMA180.h"

BMA180::BMA180(PinName mosi, PinName miso, PinName sck, PinName cs) : spi_(mosi, miso, sck), nCS_(cs) 
    {
    nCS_ = 1;

    wait_us(500);
    
    char readVersion, readID;
    char byte;
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 10MHz clock rate

    spi_.frequency(10000000);        // 10 mHz page 59 of the BMA180 datasheet
    spi_.format(8,3);                // Not conform !!! page 58 of the BMA180 datasheet)
    wait_ms(100);
    readID = read_reg(BMA180_ID);
    readVersion = read_reg(VERSION);
    
    /*pc.printf("\n\r");
    if (readID == 3) {
        pc.printf("Connected to BMA180\n\r");
        pc.printf("BMA180 Version %d\n\r", readVersion);
    } else
        pc.printf("Sorry not connected to BMA180 !!!\n\r", readID);*/

    soft_reset();   // to copy EEprom into volatile area

    //---------------------------
    byte = read_reg(CTRL_REG0);             // Unlock image writing
    byte |= 0x10;                           // Set bit 4
    write_reg(CTRL_REG0,byte);              // Have to set ee_w to
    
    //------------------------
    byte= read_reg(DIS_I2C);                // read
    byte |= 0x01;                           // set bit0 to 1, SPI only
    write_reg(DIS_I2C, byte);               // Set spi, disable i2c, page 31
    
    
    //  SET RANGO  //
    
    byte= read_reg(RANGE);                  // read
    byte &= 0xF1;                           // set to 0 all 3 bits related to range
    byte |= 0x02;                           // Rango +- 1.5g
    write_reg(RANGE, byte);                 // Set RANGO, page 27
    
    //  SET FILTER BAND WITH  //
    
    byte= read_reg(FILTER_BW);              // read
    byte &= 0x0F;                           // set to 0 all 4 bits related to filter
    byte |= 0x70;                           // Filtro 1200 Hz (luego resulta ser un filtro de 472 Hz por ultra-low noise, ver p. 28 de datas sheet)
    write_reg(FILTER_BW, byte);             // Set BW, page 27
    
    //  SET NOISE Y POWER  (mode_config)//
    
    byte= read_reg(NOISE_POWER);            // read
    byte &= 0xFC;                           // set to 0 all 2 bits related to mode configuration
    byte |= 0x01;                           // Ultra low noise
    write_reg(NOISE_POWER, byte);           // Set mode_config, page 28
    
    //-------------------------
    //byte = read_reg(CTRL_REG3);
    //byte |= 0x02;                           // set bit 1 enable interrupt
    //byte |= 0x40;                           // set bit 6 slope mode
    //byte |= 0x80;                           // set bit 7 slope alert
    //write_reg(CTRL_REG3,byte);              //
    //pc.printf("Enable interrupt bis is set ");
    
    
    
    //------------------------------
    byte = read_reg(CTRL_REG0);             // Lock image writing
    byte &= 0xEF;                           // REset  bit 4
    write_reg(CTRL_REG0,byte);              // Have to set ee_w to
    //-------------------------------------------------------------------------------------
    //pc.printf("\n\rBMA init done    \n\r");

}

void BMA180::soft_reset(void) {
    // Write a soft reset
    // to copy EEprom into volatile area, see mid page 22
    write_reg(RESET, 0xB6);             // page 48
    wait_ms(10);                        // wait 10 ms, see page 49
    //pc.printf("Soft reset, EEPROM copied    \n\r");
}

void BMA180::ReadAccels_BMA180(int* Acc) {
    char x_lsb, x_msb;
    char y_lsb, y_msb;
    char z_lsb, z_msb;
    signed short ax, ay, az;

    //------------X----------------
    x_lsb = read_reg(ACCXLSB);
    x_msb = read_reg(ACCXMSB);
    ax = (x_msb << 8) |  x_lsb ;   // combineer msb en lsb
    ax = ax >> 2;                  // Get rid of two non-value bits in LSB
    //------------Y----------------
    y_lsb = read_reg(ACCYLSB);
    y_msb = read_reg(ACCYMSB);
    ay = (y_msb << 8) | y_lsb;     // combineer msb en lsb
    ay = ay >> 2;                  // Get rid of two non-value bits in LSB
    //------------Z----------------
    z_lsb = read_reg(ACCZLSB);
    z_msb = read_reg(ACCZMSB);
    az = (z_msb << 8) |  z_lsb;    //  combineer msb en lsb
    az = az >> 2;                  // Get rid of two non-value bits in LSB

    Acc[0] = ax;
    Acc[1] = ay;
    Acc[2] = az;
}

//-----------------READ OUT the X-Y-Z values---------------

void BMA180::write_reg(uint8_t address, char data) {
    address &= 0x7F;                        //Force a write (bit 7=0)
    nCS_ = 0;                                   //Select SPI device
    wait_us(2);
    spi_.write(address);                     //Send register location
    wait_us(2);
    spi_.write(data);                        //Send value to record into register
    wait_us(2);
    nCS_ = 1;
    wait_us(2);
}

char BMA180::read_reg(uint8_t address) {
    char byte;
    address |= 0x80;                        //Force a read (bit 7=1)
    nCS_ = 0;
    wait_us(2);                             //Select SPI device
    spi_.write(address);                     //Send register location
    wait_us(2);
    byte=spi_.write(0xFF);                   //Get the data
    wait_us(2);
    nCS_ = 1;
    wait_us(2);
    return byte;
}

void BMA180::disable_int(void) {
    char byte;
    byte = read_reg(CTRL_REG0);             // Unlock image writing
    byte |= 0x10;                           // Set bit 4
    write_reg(CTRL_REG0,byte);              // Have to set ee_w to
    //-------------------------
    byte = read_reg(CTRL_REG3);
    byte &= 0xFD;                           // REset bit 1 enable interrupt
    write_reg(CTRL_REG3,byte);              //
    //pc.printf("\n\rDisable interrupt bis is set ");
    //------------------------------
    byte = read_reg(CTRL_REG0);             // Lock image writing
    byte &= 0xEF;                           // REset  bit 4
    write_reg(CTRL_REG0,byte);              // Have to set ee_w to
    //pc.printf("\n\rMBA180 in now switched off ");
}

void BMA180::AcelerometroSleep(void)      //OJO, NO ESTOY SEGURO DE QUE ESTA FUNCION ESTÉ BIEN IMPLEMENTADA
{
    char byte;
     
    byte = read_reg(0x0D);
    byte &= 0xFD;
    byte |= 0x02;
    write_reg(0x0D, byte);
}  
void BMA180::AcelerometroWakeUp(void)     //OJO, NO ESTOY SEGURO DE QUE ESTA FUNCION ESTÉ BIEN IMPLEMENTADA
{
    char byte;
     
    byte = read_reg(0x0D);
    byte &= 0xFD;
    write_reg(0x0D, byte);
}    

void BMA180::AcelerometroLeeOffsets(int * offSet)              //Lee los valores de los 3 offsets: x, y, z 
{
    char x_lsb, x_msb;
    char y_lsb, y_msb;
    char z_lsb, z_msb;
    signed short offx, offy, offz;  
     
    offx = 0;
    offy = 0;
    offz = 0; 
     
    x_msb = read_reg(0x38);
    y_msb = read_reg(0x39);
    z_msb = read_reg(0x3A);
    
    x_lsb = read_reg(0x35);
    y_lsb = read_reg(0x36) << 4;
    z_lsb = read_reg(0x36);

    //------------X----------------
    offx = (x_msb << 8) |  x_lsb ;   // combineer msb en lsb
    offx = offx >> 4;                  // Get rid of 4 non-value bits in LSB
    //------------Y----------------
    offy = (y_msb << 8) | y_lsb;     // combineer msb en lsb
    offy = offy >> 4;                  // Get rid of 4 non-value bits in LSB
    //------------Z----------------
    offz = (z_msb << 8) |  z_lsb;    //  combineer msb en lsb
    offz = offz >> 4;                  // Get rid of 4 non-value bits in LSB

    offSet[0] = offx;
    offSet[1] = offy;
    offSet[2] = offz;
}


void BMA180::AcelerometroEscribeOffsets(char * offSet)              //Escribe los valores de los 3 offsets: x, y, z 
{
    ////////////////////////// 
    // Unlock image writing //
    //////////////////////////

    char byte;
    byte = read_reg(CTRL_REG0);             // Unlock image writing
    byte |= 0x10;                           // Set bit 4
    write_reg(CTRL_REG0,byte);              // Have to set ee_w to

    char x_lsb, x_msb;
    char y_lsb, y_msb;
    char z_lsb, z_msb;
    char reg_x, reg_yz; 
    
     
    x_msb = offSet[0];
    y_msb = offSet[1];
    z_msb = offSet[2];
    
    x_lsb = offSet[3];
    y_lsb = offSet[4];
    z_lsb = offSet[5];
     
     
    // offset_finetuning to 11
    char fine_tu;
    fine_tu = read_reg(0x22);
    fine_tu &= 0xFC;
    fine_tu |= 0x01;
    write_reg(0x22,fine_tu);
    
    ///////////////////////////////
    /// ESTABLECE EL OFFSET EN X //
    ///////////////////////////////
    
    //Enable offset X
    fine_tu = read_reg(0x0E);
    fine_tu &= 0x7F;
    fine_tu |= 0x80;
    write_reg(0x0E,fine_tu);
    
    write_reg(0x38,x_msb);
    
    //Set X
    reg_x = read_reg(0x35);
    reg_x &= 0x0F;
    x_lsb = x_lsb << 4;
    reg_x |= x_lsb;
    write_reg(0x35,reg_x);
    
    //Disable offset X y Enable Y
    fine_tu &= 0x7F;
    fine_tu |= 0x40;
    write_reg(0x0E,fine_tu);
    
    ///////////////////////////////
    /// ESTABLECE EL OFFSET EN Y //
    ///////////////////////////////
    
    write_reg(0x39,y_msb);
    
    reg_yz = read_reg(0x36);
    reg_yz &= 0xF0;
    reg_yz |= y_lsb;
    write_reg(0x36,reg_yz);
    
    //Disable offset Y y Enable Z
    fine_tu &= 0xBF;
    fine_tu |= 0x20;
    write_reg(0x0E,fine_tu);
    
    ///////////////////////////////
    /// ESTABLECE EL OFFSET EN Z //
    ///////////////////////////////
    
    write_reg(0x3A,z_msb);
    
    reg_yz &= 0x0F;
    reg_yz |= z_lsb << 4;
    write_reg(0x36,reg_yz);
    
    //Disable offset Z
    fine_tu &= 0xDF;
    write_reg(0x0E,fine_tu);
    
    // offset_finetuning to 01
    fine_tu = read_reg(0x22);
    fine_tu &= 0xFC;
    fine_tu |= 0x01;
    write_reg(0x22,fine_tu);
    
    //////////////////////// 
    // Lock image writing //
    ////////////////////////
    
    byte = read_reg(CTRL_REG0);             // Lock image writing
    byte &= 0xEF;                           // REset  bit 4
    write_reg(CTRL_REG0,byte);              // Have to set ee_w to
}