#include "mbed.h"

// Parametros variables en cada aplicación*****************

#define FEQ_ACQ 250
#define TSYNC 1250  // Periodo de sincronización en microsegundos
#define TREAD 100   // Periodo de lectura de sensores en microsegundos

DigitalOut led1(p29);   // Salida digital conectada al led indicador 1
DigitalOut led2(p26);   // Salida digital conectada  al led indicador 2  

Serial pc(USBTX, USBRX);

DigitalIn sensor1(p19);     // Entrada digital del sensor 1
DigitalIn sensor2(p20);     // Entrada digital del sensor 1

Ticker leeSensor;           // Ticker con la función de leer periódicamente la salida de los sensores magnéticos
Ticker sincro;              // Ticker con la función de cambiar de estado la señal de sincronización

DigitalOut outS(p30);       // Señal de sincronización de las cámaras (1)
DigitalOut outS2(p34);       // Señal de sincronización de las cámaras (2)

DigitalOut myled(LED1);     // Led utilizado para debugging

Timer t;

// Función que lee periódicamente la salida de los sensores magnéticos
void lecturaSensores() {    
    // Se envían los datos de los sensores por el puerto serie al PC
    /*pc.putc('1');       // Se envía un byte con el valor 1 antes del valor del primer sensor
    pc.putc(sensor1);   // Se envía el valor digital actual del sensor 1*/
    //pc.putc(rand()%2);  // Debugging
    led1 = sensor2;     // Se actualiza el estado del led indicador 1 de acuerdo al valor actual del sensor 1
    
    /*pc.putc('2');       // Se envía un byte con el valor 2 antes del valor del segundo sensor
    pc.putc(sensor2);   // Se envía el valor digital actual del sensor 1*/
    ///pc.putc(rand()%2);  // Debugging
    led2 = sensor1;     // Se actualiza el estado del led indicador 2 de acuerdo al valor actual del sensor 2
}

// Función que cambia de estado la señal de sincronización
void sincroniza() {
    outS = !outS;   // Se invierte el estado de la salida del pin
    outS2 = !outS2;
}

int main() {    
    pc.baud(460800);    // Configuración de la velocidad de comunicación del puerto serie
    char car;           // Variable auxiliar en la que se guardará el valor del último caracter enviado por el PC
    myled = 0;  // Inicialización de señales
    
    pc.printf("Listo para enviar.\n\r");
    
    while(1) {  // Bucle infinito
        if(pc.readable()){  // Si existe algún byte en el buffer que ha enviado el PC
            car = pc.getc();    // Se lee el byte
            if(car == 'a'){ // Si es el carácter 'a', indica el inicio de la adquisición
                leeSensor.attach_us(&lecturaSensores, TREAD); // Se activa el ticker de lectura de los sensores con periodo TREAD en microsegundos
                sincro.attach_us(&sincroniza, TSYNC); // Se activa el ticker de control de estado de la señal de sincronización con periodo TSYNC en microsegundos
                t.start();
                myled = 1;
            }else if(car == 's'){   // es el carácter 'a', indica el final de la adquisición
                leeSensor.detach(); // Se descativan los ticker
                sincro.detach();
                pc.printf("Duracion: %d\n\r",  t.read_us());
                t.stop();
                t.reset();
                myled = 0;  // Se resetean las señales
                led1 = 0;
                led2 = 0;
                outS = 1;   // La señal que sale del micro se va a invertir al pasar por el transistor, por lo que para que la cámara vea un flanco de subida al inicio de la captura de imágenes, se debe enviar un flanco de subida desde el micro
                outS2 = 1;
            }
        }         
    }
}