#include "mbed.h"
 
 
#define CMD_READ    0x03
#define CMD_WRITE   0x02
#define CMD_RDMR    0x05
#define CMD_WRMR    0x01
 
 
// The 23LCV1024 is a 1 Mbit Serial SRAM, with 128K * 8 bits organized into 32 byte pages
// A 24 bit address, 00000h - 1FFFFh, is used to address the memory location
 
// In this library, we will address the memory in blocks of 256 bytes, of which there are 512 in total
// (2^1) (2^8 = 256 blocks) (2^8 = 256 bytes)
// 512 blocks a 256 bytes
 
 
class SRAM23LCV1024 {
    public:
        SRAM23LCV1024(SPI& spi, PinName cs);
    
        int getReadMode();
        
        int readBytes(int address, char* buffer, int length);
        int writeBytes(int address, char* buffer, int length);
        
    private:
        SPI& _spi;
        DigitalOut _cs;   
};