/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */

#ifndef KXR94_H
#define KXR94_H
 
#include "mbed.h"

#define CONVERTX       0x00
#define CONVERTY       0x01
#define CONVERTZ       0x02
#define READREG        0x03
#define WRITEREG       0x04
#define CONVERTAUX     0x05


/*-------------Hardware connections-------------
VIO----- mbed Vout (3.3 Volt)
SDI----- mbed mosi (p5)
SDO----- mbed miso (p6)
SCK----- mbed sck  (p7)
CS------ mbed (p8)          // chip select
GND----- mbed GND (0 Volt)
VDO----- mbed Vout (3.3 Volt)
there are no additional external components used
//----------------------------------------------*/

/**
 * KXR94 triple axis, digital interface, accelerometer.
 */
class KXR94 {

public:
    /**
     * Constructor.
     *
     * @param mosi mbed pin to use for MOSI line of SPI interface.
     * @param miso mbed pin to use for MISO line of SPI interface.
     * @param sck mbed pin to use for SCK line of SPI interface.
     * @param cs mbed pin to use for not chip select line of SPI interface.
     */
    KXR94(PinName mosi, PinName miso, PinName sck, PinName cs);
    
    void write_reg(char data);
    char read_reg();

    void ReadAccels_KXR94(int*);
    
    void AcelerometroSleep(void);                    //Pone el acelerometro en sleep mode para no consumir energía
    void AcelerometroWakeUp(void);                   //Pone el acelerometro preparado para medir
    
    private:

    SPI        spi_;
    DigitalOut nCS_;

};

#endif /* KXR94_H */