/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef PARAMETROSCALIBRACION_H
#define PARAMETROSCALIBRACION_H

#define NCARACTERES 16
#define NCARACTERESLECTURA 64

#include "mbed.h"
#include "ScreenManager.h"
#include "SelecManager.h"
#include <string.h>
#include <stdlib.h>

// Valores de calibración por defecto
// OFFSET
#define AX 2086.500488
#define AY 2070.410645
#define AZ 2057.436523
// Sensibilidad
#define KX 0.011837
#define KY 0.011808
#define KZ 0.011850

// Clase encargada de guardar y cargar los parámetros de calibración del sensor
// En total son 6 parámetros:
// 3 de offset y 3 de conversión a unidades física
class ParametrosCalibracion{
    public:        
    static void leerValores(float* valores);    // Esta función guarda en un array de 6 float los valores de calibración    
    static void createDefaults();      // Crea un fichero de valores de calibración. Dichos valores serán los valores por defecto
    static void saveValores(float valores[]);          // Guarda 6 nuevos valores de calibración
};


#endif