/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef CONFIGURACION_H
#define CONFIGURACION_H

#define NCARACTERES 16
#define NCARACTERESLECTURA 64

#include "mbed.h"
#include "ScreenManager.h"
#include "SelecManager.h"
#include <string.h>
#include <stdlib.h>

// CLase encargada de guardar y cargar la configuración
class Configuracion{
    public:
    Configuracion();    // EL construtor carga los valores de configuracion o crea una configuracion inicial en caso de no existir
    
    void getVelocidadAdquisicionString(char buff[]);
    int getVelocidadAdquisicion();
    void getIdioma(char buf[]);
    void getFormaSeleccion(char buf[]);
    
    void setVelocidadAdquision(int nuevaVelocidadAdqusicion);
    void setIdioma(char nuevoIdioma[]);
    void setFormaSeleccion(char nuevaFormaSeleccion[]);
    
    
    void restoreSettings(); // Vuelve a los valóres de fábrica
    
    private:
    // Parámetros
    char velocidadAdquisicion[NCARACTERES];
    char idioma[NCARACTERES];
    char formaSeleccion[NCARACTERES];
    
    void getParam(FILE* file, char nameParam[], char buf[]);
    void createFile();      // Crea o sobreescribe un archivo con los parámetros de configuración
    
    void setDefaults(); // Carga los valores predeterminados
    
    
};


#endif