/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef SCREENMANAGER_H
#define SCREENMANAGER_H

#define NUMSCREENS 25
#define NIDIOMAS 2
#define NCARSCREEN 16

#include "Screen.cpp"
#include <string.h> 

class ScreenManager {

public:
    /**
     * Constructor.
     *
     */
    ScreenManager(DogMLCD* lcdScreen);
    
    void selectGroup(int groupID);      // Se selecciona el grupo mostrado actualmente. Llamamar a esta funcioón justo antes de cambiar a una pantalla o llamar initialize para que se muestre la actual correctamente
    int addScreen(Screen* screen, char name[NCARSCREEN], int groupID);   // Devuelve el índice asignado a la nueva pantalla
    void changeScreen(char nameNextScreen[NCARSCREEN]);  
    void backScreen();               // Vuelve a la pantalla anterior, devuelve el índice de la pantalla anterior
    void getLastScreen(char buff[]);    // Devuelve el nombre de la pantalla anterior
    int getnScreen(int groupID);       // Devuelve el número de pantallas
    int getCurrentGroupID();            //Devuelve el grupo de patallas seleccionado actual
    char *getCurrentScreen();      // Devuelve el nombre de la pantalla actual
    
    void initialize();  // Iniciliza la pantalla actual
    void update();
    
    
    private:
    int currentGroupID; // Grupo actual
    int currentScreen;  // Índice de la pantalla actual
    int lastScreen;     // Índice de la pantalla anterior
    int nScreens[NIDIOMAS];       // Número total de pantallas añadidas de cada grupo
    Screen* screens[NIDIOMAS][NUMSCREENS];
    char screenName[NIDIOMAS][NUMSCREENS][NCARSCREEN];
    DogMLCD* lcd;

};

#endif