/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#include "ViajesGuardados.h"

extern ScreenManager SC;
extern SistemaArchivos SA;

extern OpcionesViaje opcionesViaje;
extern OpcionesViaje opcionesViajeEN;

ViajesGuardados::ViajesGuardados(char newNoRides[]){
    strcpy(noRides, newNoRides);
}

void ViajesGuardados::initialize(DogMLCD* lcd){
    ifContinuar = true;
    // Se borran los elementos añadidos anteriormente
    borrarElementos();
    // Se cargan los viajes guardados
    SA.reloadRideNames();
    if(SA.getNrides() > 0){   // Si hay algún viaje guardado
        // Se añaden a la lista de elementos los viajes guardados
        for(int i = 0; i < SA.getNrides(); i++){
            addElement(SA.getNameRide(i), "rOptions");
        }
        ListaSelec::initialize(lcd);
    }else{  // Si no existe nigún viaje guardado
        // Se muestra por pantalla un mensaje informándolo
        // select font to use:
        lcd->XFont = xfont_8;
        
        // Se desabilita el botón "continuar"
        ifContinuar = false;
        
        // Se escribe el nombre
        lcd->XString(OFFSETX, OFFSETY, noRides);
        
        // transmit work screen to physical screen:
        lcd->Flush();
    }
}

void ViajesGuardados::button5pressed(DogMLCD* lcd){
    // Se le pasa a la pantalla de menú del viaje el nombre del viaje seleccionado
    opcionesViaje.setViaje(getElement(getSelect()));
    opcionesViajeEN.setViaje(getElement(getSelect()));
    
    // Se llama a la función padre
    if(ifContinuar){
        ListaSelec::button5pressed(lcd);
    }
}