/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#include "FechaHoraConf.h"

extern ScreenManager SC;
extern FechaHora FH;

extern DigitalIn boton1;
extern DigitalIn boton2;
extern DigitalIn boton3;
extern DigitalIn boton4;
extern DigitalIn boton5;

extern Timer t;

FechaHoraConf::FechaHoraConf(char newAdvice[], char newAdvice2[], char newAdvice3[], char newdateTitle[], char newtimeTitle[]){
    strcpy(advice, newAdvice);
    strcpy(advice2, newAdvice2);
    strcpy(advice3, newAdvice3);

    strcpy(dateTitle, newdateTitle);
    strcpy(timeTitle, newtimeTitle);
}

// Tecla arriba
void FechaHoraConf::button1pressed(DogMLCD* lcd){
    char aux[5];
    switch(getSelect()){
        // día
        case 0:
            // Dependiendo del mes el límite del dia es diferente
            if(FH.getNmonth() == 2 && FH.getNday()+1 > 28){       // Febrero
                FH.setNday(1);
            }else if((FH.getNmonth() == 1 || FH.getNmonth() == 3 || FH.getNmonth() == 5 || FH.getNmonth() == 7 || FH.getNmonth() == 8 || FH.getNmonth() == 10 || FH.getNmonth() == 12) && FH.getNday()+1 > 31){    // Meses con 31 días
                FH.setNday(1);                
            }else if((FH.getNmonth() == 4 || FH.getNmonth() == 6 || FH.getNmonth() == 9 || FH.getNmonth() == 11) && FH.getNday()+1 > 30){    // Meses con 31 días
                FH.setNday(1);            
            }else{  // sino se aumenta un día
                FH.setNday(FH.getNday()+1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getDay(aux);
            aux[2] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;
        // mes
        case 1:
            // Si el mes es mayor que 12 se devuelve al 1
            if((FH.getNmonth()+1) > 12){
                FH.setNmonth(1);
            }else{  // sino se aumenta un mes
                FH.setNmonth(FH.getNmonth()+1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getMonth(aux);
            aux[2] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;
        // año
        case 2:
            // Si el año es mayor que 1099(2999) se devuelve al 0(1900)
            if((FH.getNyear()+1) > 1099){
                FH.setNyear(0);
            }else{  // sino se aumenta un año
                FH.setNyear(FH.getNyear()+1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getYear(aux);
            aux[4] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;
        // hora
        case 3:
            // Si la hora es mayor que 23 se devuelve al 0
            if((FH.getNhour()+1) > 23){
                FH.setNhour(0);
            }else{  // sino se aumenta una hora
                FH.setNhour(FH.getNhour()+1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getHour(aux);
            aux[2] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;   
        // minuto
        case 4:
            // Si el minuto es mayor que 59 se devuelve al 0
            if((FH.getNminute()+1) > 59){
                FH.setNminute(0);
            }else{  // sino se aumenta un minuto
                FH.setNminute(FH.getNminute()+1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getMinute(aux);
            aux[2] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;
        // segundo
        case 5:
            // Si el segundo es mayor que 59 se devuelve al 0
            if((FH.getNsecond()+1) > 59){
                FH.setNsecond(0);
            }else{  // sino se aumenta un segundo
                FH.setNsecond(FH.getNsecond()+1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getSecond(aux);
            aux[2] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;
    }
    // transmit work screen to physical screen:
    lcd->Flush();
}

// Tecla abajo
void FechaHoraConf::button4pressed(DogMLCD* lcd){
    char aux[5];
    switch(getSelect()){
        // día
        case 0:
            // Dependiendo del mes el límite del dia es diferente
            if(FH.getNmonth() == 2 && FH.getNday()-1 < 0){       // Febrero
                FH.setNday(28);
            }else if((FH.getNmonth() == 1 || FH.getNmonth() == 3 || FH.getNmonth() == 5 || FH.getNmonth() == 7 || FH.getNmonth() == 8 || FH.getNmonth() == 10 || FH.getNmonth() == 12) && FH.getNday()-1 < 0){    // Meses con 31 días
                FH.setNday(31);                
            }else if((FH.getNmonth() == 4 || FH.getNmonth() == 6 || FH.getNmonth() == 9 || FH.getNmonth() == 11) && FH.getNday()-1 < 0){    // Meses con 31 días
                FH.setNday(30);            
            }else{  // sino se aumenta un día
                FH.setNday(FH.getNday()-1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getDay(aux);
            aux[2] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;
        // mes
        case 1:
            // Si el mes es mayor que 12 se devuelve al 1
            if((FH.getNmonth()-1) < 1){
                FH.setNmonth(12);
            }else{  // sino se aumenta un mes
                FH.setNmonth(FH.getNmonth()-1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getMonth(aux);
            aux[2] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;
        // año
        case 2:
            // Si el año es mayor que 1099(2999) se devuelve al 0(1900)
            if((FH.getNyear()-1) < 0){
                FH.setNyear(1099);
            }else{  // sino se aumenta un año
                FH.setNyear(FH.getNyear()-1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getYear(aux);
            aux[4] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;
        // hora
        case 3:
            // Si la hora es mayor que 23 se devuelve al 0
            if((FH.getNhour()-1) < 0){
                FH.setNhour(23);
            }else{  // sino se aumenta una hora
                FH.setNhour(FH.getNhour()-1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getHour(aux);
            aux[2] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;   
        // minuto
        case 4:
            // Si el minuto es mayor que 59 se devuelve al 0
            if((FH.getNminute()-1) < 0){
                FH.setNminute(59);
            }else{  // sino se aumenta un minuto
                FH.setNminute(FH.getNminute()-1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getMinute(aux);
            aux[2] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;
        // segundo
        case 5:
            // Si el segundo es mayor que 59 se devuelve al 0
            if((FH.getNsecond()-1) < 0){
                FH.setNsecond(59);
            }else{  // sino se aumenta un segundo
                FH.setNsecond(FH.getNsecond()-1);
            }
            
            // Se actualiza el tiempo bruto
            FH.updateRawTime();
            
            // Se cambia el texto de pantalla
            FH.getSecond(aux);
            aux[2] = '\0';
            changeElementText(aux, getSelect(), lcd);
                           
            // Se redibuja la selección
            dibujarSeleccion(getSelect(), lcd);
            break;
    }
    // transmit work screen to physical screen:
    lcd->Flush();
}

// Tecla izquierda
void FechaHoraConf::button2pressed(DogMLCD* lcd){
    // Sólo se puede mover la seleccón a la izquierda si no se está en el elemento 0
    if(getSelect() > 0){
        // Se deselecciona el elemento seleccionado actualmente
        borrarSeleccion(getSelect(), lcd);
        setSelect(getSelect()-1);
        // Se pinta la nueva selección
        dibujarSeleccion(getSelect(), lcd);
        
        // transmit work screen to physical screen:
        lcd->Flush();  
    }    
}

// Tecla derecha
void FechaHoraConf::button3pressed(DogMLCD* lcd){
    // Sólo se puede mover la seleccón a la derecha si no se está en el elemento 5
    if(getSelect() < 5){
        // Se deselecciona el elemento seleccionado actualmente
        borrarSeleccion(getSelect(), lcd);
        setSelect(getSelect()+1);
        // Se pinta la nueva selección
        dibujarSeleccion(getSelect(), lcd);
        
        // transmit work screen to physical screen:
        lcd->Flush();  
    }
}

void FechaHoraConf::button5pressed(DogMLCD* lcd){
    
}

void FechaHoraConf::initialize(DogMLCD* lcd){
    // Se borran los elementos anteriores
    borrarElementos();
        
    // select font to use:
    lcd->XFont = xfont_8;
    
    FH.update();    // Se actualiza la fecha y hora
    // Se inicia el temporizador que se usará para actualizar la hora
    t.reset();
    t.start();
    
    // Se escribe el título de fecha
    lcd->XString(OFFSETXTITLES, OFFSETY + 8*0, dateTitle);
    
    // Se escribe el título de hora
    lcd->XString(OFFSETXTITLES, OFFSETY + 8*2, timeTitle);
    
    char aux[5];
    
    // Se añade el elemento día
    FH.getDay(aux);
    aux[2] = '\0';
    addElement(aux, OFFSETX, OFFSETY + 8*1); 
    
    // Se añade el elemento mes
    FH.getMonth(aux);
    aux[2] = '\0';
    addElement(aux, OFFSETX+21, OFFSETY + 8*1);    
    
    // Se añade el elemento año
    FH.getYear(aux);
    aux[4] = '\0';
    addElement(aux, OFFSETX+42, OFFSETY + 8*1);
    
    // Se añade el elemento hora
    FH.getHour(aux);
    aux[2] = '\0';
    addElement(aux, OFFSETX, OFFSETY + 8*3);    
    
    // Se añade el elemento minuto
    FH.getMinute(aux);
    aux[2] = '\0';
    addElement(aux, OFFSETX+21, OFFSETY + 8*3);    
    
    // Se añade el elemento segundo
    FH.getSecond(aux);
    aux[2] = '\0';
    addElement(aux, OFFSETX+42, OFFSETY + 8*3);
    
    // Se muestran dos puntos para separar cada uno de los valores
    lcd->XString(20,OFFSETY + 8, ":");
    lcd->XString(41,OFFSETY + 8, ":");
    lcd->XString(20,OFFSETY + 8*3, ":");
    lcd->XString(41,OFFSETY + 8*3, ":");
    
    // Se muestran todos los elementos
    for(int i = 0; i < nElementos; i++){
        lcd->XString(elementPos[i][0], elementPos[i][1], element[i]);
    }
    
    setSelect(0);
    // Se dibuja la selección por defecto    
    dibujarSeleccion(getSelect(), lcd);
    
    // Se escribe el consejo en la parte inferior de la pantalla
    lcd->XString(OFFSETX, HEIGHT - 8*3, advice);
    lcd->XString(OFFSETX, HEIGHT - 8*2, advice2);
    lcd->XString(OFFSETX, HEIGHT - 8, advice3);
    
    // transmit work screen to physical screen:
    lcd->Flush();
}

void FechaHoraConf::dibujarSeleccion(char nElemento, DogMLCD* lcd){
    if(nElemento == 2){ // Si el elemento es el 2 (el del año) el recuadro de selección es más grande
        drawSelection(elementPos[nElemento][0]-2, elementPos[nElemento][1]-2, ANCHOSELECCION4, ALTOSELECCION, lcd);
    }else{
        drawSelection(elementPos[nElemento][0]-2, elementPos[nElemento][1]-2, ANCHOSELECCION2, ALTOSELECCION, lcd);
    }
}

void FechaHoraConf::borrarSeleccion(char nElemento, DogMLCD* lcd){
    if(nElemento == 2){ // Si el elemento es el 2 (el del año) el recuadro de selección es más grande
        drawDeselection(elementPos[nElemento][0]-2, elementPos[nElemento][1]-2, ANCHOSELECCION4, ALTOSELECCION, lcd);
    }else{
        drawDeselection(elementPos[nElemento][0]-2, elementPos[nElemento][1]-2, ANCHOSELECCION2, ALTOSELECCION, lcd);
    }
}

void FechaHoraConf::update(DogMLCD* lcd){
    // Si no se está en los segundos se actualiza cada segundo la hora
    if(getSelect() < 5){
        if(t.read_ms() >= 1000){
            t.reset();
            t.start();
            // Se actualiza la hora
            FH.update();
            
            char aux[5];
            // Se cambian los valores de los segundos, los minutos y las horas
            // Se añade el elemento hora
            FH.getHour(aux);
            aux[2] = '\0';
            changeElementText(aux, 3, lcd);
            
            // Se añade el elemento minuto
            FH.getMinute(aux);
            aux[2] = '\0';
            changeElementText(aux, 4, lcd);
            
            // Se añade el elemento segundo
            FH.getSecond(aux);
            aux[2] = '\0';
            changeElementText(aux, 5, lcd);
            
            // Si la seleccion estaba en alguno de estos elementos se ha borrado, así que se vuelve a pintar
            if(getSelect() > 2){                
                dibujarSeleccion(getSelect(), lcd);
            }
            
            // transmit work screen to physical screen:
            lcd->Flush();
        }
    }
    
    // Se llama a la función padre
    Seleccion::update(lcd);
}

void FechaHoraConf::changeElementText(char newText[], int nElemento, DogMLCD* lcd){
    // Se borra valor actual
    if(nElemento == 2){ // Si el elemento es el 2 (el del año) el recuadro de selección es más grande
        lcd->Rect(elementPos[nElemento][0]-2, elementPos[nElemento][1]-2, elementPos[nElemento][0]-2 + ANCHOSELECCION4, elementPos[nElemento][1]-2 + ALTOSELECCION, DOGMLCD_full, wipe);
    }else{
        lcd->Rect(elementPos[nElemento][0]-2, elementPos[nElemento][1]-2, elementPos[nElemento][0]-2 + ANCHOSELECCION2, elementPos[nElemento][1]-2 + ALTOSELECCION, DOGMLCD_full, wipe);
    }
    // Se actualiza el texto del elemento
    strcpy(element[nElemento], newText);
    
    // Se pinta el nuevo texto
    lcd->XString(elementPos[nElemento][0], elementPos[nElemento][1], element[nElemento]);
}
    

int FechaHoraConf::addElement(char text[], char posX, char posY){
    strcpy(element[nElementos], text);
    elementPos[nElementos][0] = posX;
    elementPos[nElementos][1] = posY;
    nElementos++;
    return nElementos - 1;
}