#include "mbed.h"
#include "Teclado.h"

extern ScreenManager SC;

extern DigitalIn boton1;
extern DigitalIn boton2;
extern DigitalIn boton3;
extern DigitalIn boton4;
extern DigitalIn boton5;
   
void Teclado::initialize(DogMLCD* lcd){
    // Se inicializa la variable que guarda el último nombre introducido
    for(int i = 0; i < MAXCARACTERESESCRITURA; i++){
        nombre[i] = 0;
    }
    
    // Se inicializa la selección
    setSelect(0);

    indiceEscritura = 0;
        
    mostrarRecuadro(lcd);
    
    // Por defecto se muestran caracteres de letras minusculas
    asignarMinusculas();
    ifMayus = false;
    
    // Se muestran los caracteres normales    
    mostrarCaracteres(lcd);
    
    // Se muestran los caracteres especiales
    mostrarEspeciales(lcd);  
    
    // Se inicializa la selección
    Xsel = 0;
    Ysel = 0;
    lastXsel = 0;
    lastYsel = 0;
    // Se pinta la selección por defecto
    drawSelection(OFFSETX-2, WRITTENSPACE, CARACTER11, CARACTER11, lcd);
    
    // transmit work screen to physical screen:
    lcd->Flush();  

}

// El botón 5 envía a la pantalla correspondiente según el elemento seleccionado
void Teclado::button5pressed(DogMLCD* lcd){
    
    // Si no es una tecla especial
    if(m[Ysel][Xsel] > ULTIMOCARACTERESPECIAL){
        // select font to use:
        lcd->XFont = xfont_8;
        if(indiceEscritura < MAXCARACTERESESCRITURA){
            // Si se ha pulsado sobre un caracter normal se añade este al recuadro donde se muestra lo escrito
            if(m[Ysel][Xsel] > ULTIMOCARACTERESPECIAL){   // Si el elemento no es un caracter o tecla especial
                // Se asigna el caracter en la cedena
                nombre[indiceEscritura] = m[Ysel][Xsel];
                indiceEscritura++;
                // Se actualiza el caracter finde cadena
                if(indiceEscritura < MAXCARACTERESESCRITURA){
                    nombre[indiceEscritura] = '\0';
                }
                
                // Se borra la cadena mostrada actualmente
                lcd->Rect(POSCADENAX,1,WIDTH-2, WRITTENSPACE-2, DOGMLCD_full, wipe);
                
                // Se escribe la nueva cadena
                lcd->XString(POSCADENAX, 1, nombre);
            }
        }
    }else{      // Teclas especiales
        if(m[Ysel][Xsel] == SPACEBAR){  // Barra espaciadora
            // Se aplica un espacio
            nombre[indiceEscritura] = ' ';
            indiceEscritura++;
            // Se actualiza el caracter fin de cadena
            if(indiceEscritura < MAXCARACTERESESCRITURA){
                nombre[indiceEscritura] = '\0';
            }
        }else if(m[Ysel][Xsel] == MAYUS){
            // Se intercambian los caracteres actuales mayúsculas/minúculas
            // Primero se limpia la pantalla
            lcd->Clear();            
            mostrarRecuadro(lcd);
            // Se asignan los caracteres que corresponden
            if(ifMayus){                
                asignarMinusculas();
                ifMayus = false;
            }else{
                asignarMayusculas();
                ifMayus = true;
            }
            // Se muestran los caracteres normales    
            mostrarCaracteres(lcd);
            
            // Se muestran los caracteres especiales
            mostrarEspeciales(lcd);  
            
            // Se escribe la selección del mayus
            drawSelection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11-1, lcd);
            
            // select font to use:
            lcd->XFont = xfont_8;
            
            // Se escribe la nueva cadena
            lcd->XString(POSCADENAX, 1, nombre);
            
            // transmit work screen to physical screen:
            lcd->Flush();  
        }else if(m[Ysel][Xsel] == BACK){
            // Se borra el último caracter de la cadena escribiendo en su lugar un caracter fin de cadena
            if(indiceEscritura > 0){ // Si hay algo que borrar
                indiceEscritura--;
                nombre[indiceEscritura] = '\0';
                
                // Se borra la cadena mostrada actualmente
                lcd->Rect(POSCADENAX,1,WIDTH-2, WRITTENSPACE-2, DOGMLCD_full, wipe);
                
                // Se escribe la nueva cadena
                lcd->XString(POSCADENAX, 1, nombre);
            }
        }else if(m[Ysel][Xsel] == APLICAR){
            SC.changeScreen(nameNextScreen);
        }
    }
    
    // transmit work screen to physical screen:
    lcd->Flush();
}

void Teclado::mostrarEspeciales(DogMLCD* lcd){
    // Se pinta la flecha de borrado de caracteres
    lcd->Rect(OFFSETX + CARACTER11*10 + 2, WRITTENSPACE + CARACTER11*3 + 3, OFFSETX + CARACTER11*10 + 2 + 6, WRITTENSPACE + CARACTER11*3 + 3 + 5);
    lcd->LineV(OFFSETX + CARACTER11*10 + 1, WRITTENSPACE + CARACTER11*3 + 4, WRITTENSPACE + CARACTER11*3 + 7);
    lcd->LineV(OFFSETX + CARACTER11*10, WRITTENSPACE + CARACTER11*3 + 5, WRITTENSPACE + CARACTER11*3 + 6);
    
    // Se pinta la flecha de mayus
    lcd->Rect(OFFSETX + 2, WRITTENSPACE + CARACTER11*4 + 5, OFFSETX + 2 + 3, WRITTENSPACE + CARACTER11*4 + 5 + 4);
    lcd->LineH(OFFSETX + 1, WRITTENSPACE + CARACTER11*4 + 4, OFFSETX + 1 + 5);
    lcd->LineH(OFFSETX + 2, WRITTENSPACE + CARACTER11*4 + 3, OFFSETX + 2 + 3);
    lcd->LineH(OFFSETX + 3, WRITTENSPACE + CARACTER11*4 + 2, OFFSETX + 3 + 1);
    
    // Se pinta el intro (abarca el espacio de dos elementos de la matriz)
    lcd->Rect(OFFSETX + CARACTER11*10 + 5, WRITTENSPACE + CARACTER11*4 + 1, OFFSETX + CARACTER11*10 + 5 + 2, WRITTENSPACE + CARACTER11*4 + 5);
    lcd->Rect(OFFSETX + CARACTER11*9 + 3, WRITTENSPACE + CARACTER11*4 + 6, OFFSETX + CARACTER11*9 + 3 + 15, WRITTENSPACE + CARACTER11*4 + 6 + 2);
    lcd->LineV(OFFSETX + CARACTER11*9 + 2, WRITTENSPACE + CARACTER11*4 + 5, WRITTENSPACE + CARACTER11*4 + 5 + 4);
    lcd->LineV(OFFSETX + CARACTER11*9 + 1, WRITTENSPACE + CARACTER11*4 + 6, WRITTENSPACE + CARACTER11*4 + 6 + 2);
    lcd->LineV(OFFSETX + CARACTER11*9 , WRITTENSPACE + CARACTER11*4 + 7, WRITTENSPACE + CARACTER11*4 + 7);
    
    // Se pinta la barra espaciadora (abarca el espacio de 8 elementos de la matriz)
    lcd->Rect(OFFSETX + CARACTER11 + 3, WRITTENSPACE + CARACTER11*4 + 6, OFFSETX + CARACTER11 + 79, WRITTENSPACE + CARACTER11*4 + 6 + 1);
    lcd->Rect(OFFSETX + CARACTER11 + 3, WRITTENSPACE + CARACTER11*4 + 2, OFFSETX + CARACTER11 + 3 + 1, WRITTENSPACE + CARACTER11*4 + 2 + 3);
    lcd->Rect(OFFSETX + CARACTER11 + 78, WRITTENSPACE + CARACTER11*4 + 2, OFFSETX + CARACTER11 + 79, WRITTENSPACE + CARACTER11*4 + 2 + 3);
}

void Teclado::seleccionarAplicar(DogMLCD* lcd){
    drawSelection(OFFSETX + CARACTER11 + 84, WRITTENSPACE + CARACTER11*4, 24, 10, lcd);
}

void Teclado::deseleccionarAplicar(DogMLCD* lcd){
    drawDeselection(OFFSETX + CARACTER11 + 84, WRITTENSPACE + CARACTER11*4, 24, 10, lcd);
}

void Teclado::seleccionarBarraEspaciadora(DogMLCD* lcd){
    drawSelection(OFFSETX + CARACTER11 - 1, WRITTENSPACE + CARACTER11*4, 84, 10, lcd);
}

void Teclado::deseleccionarBarraEspaciadora(DogMLCD* lcd){
    drawDeselection(OFFSETX + CARACTER11 - 1, WRITTENSPACE + CARACTER11*4, 84, 10, lcd);
}

void Teclado::mostrarCaracteres(DogMLCD* lcd){
    // select font to use:
    lcd->XFont = xfont_11;
    
    // Se recorre la matriz mostrando todo lo que no sean caracteres o teclas especiales
    for(int i = 0; i < FILASMATRIZ; i++){
        for(int j = 0; j < COLUMNASMATRIZ; j++){
            if(m[i][j] > ULTIMOCARACTERESPECIAL){   // SI el elemento no es un caracter o tecla especial
                // se muestra
                lcd->XChar(OFFSETX + CARACTER11*j, WRITTENSPACE + CARACTER11*i, m[i][j]);
            }
        }
    }   
}

void Teclado::mostrarRecuadro(DogMLCD* lcd){
    lcd->Frame(0, 0,WIDTH-1, WRITTENSPACE-1);
}

// El botón 1 sube la selección al elemento superior al actual
void Teclado::button1pressed(DogMLCD* lcd){
    // Si sales de los elementos seleccionables no se cambia de selección
    if((Ysel - 1) >= 0){
        // Si se venía de la última fila (teclas especiales)
        if(Ysel == (FILASMATRIZ-1) ){         
            // Si se venía la barra espaciadora se selecciona esta
            if(m[Ysel][Xsel] == SPACEBAR){
                deseleccionarBarraEspaciadora(lcd);
            }else if(m[Ysel][Xsel] == APLICAR){ // Si se venía de la tecla aplicar se selecciona esta
                deseleccionarAplicar(lcd);
            }else{
                // se venía del mayus mayus
                drawDeselection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11-1, lcd);
            }
        }else{
            // Se deselecciona la tecla anterior
            drawDeselection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11, lcd);
        }
        
        // Se selecciona el nuevo elemento
        Ysel--;
        
        // Se escribe la nueva selección
        drawSelection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11, lcd);
        
        // transmit work screen to physical screen:
        lcd->Flush();
    }
}

// El botón 2 desplaza la selección al elemento izquierdo al actual
void Teclado::button2pressed(DogMLCD* lcd){
    // Si sales de los elementos seleccionables no se cambia de selección
    if((Xsel - 1) >= 0){
        // Si se está en la última fila
        if(Ysel == (FILASMATRIZ-1) ){
            // Se se venía de la tecla aplicar
            if(m[Ysel][Xsel] == APLICAR){
                deseleccionarAplicar(lcd);
                seleccionarBarraEspaciadora(lcd);
                // Se mueven dos elementos a la izquierda
                Xsel -= 2;
            }else{
                deseleccionarBarraEspaciadora(lcd);
                // Se mueve la selección al elemento de la izquierda
                Xsel = 0;
                // Se escribe la nueva selección (la selección es CARACTER11-1 por razones de espacio) (tecla mayus)
                drawSelection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11-1, lcd);
            }
        }else{        
            // Se borra la selección anterior
            drawDeselection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11, lcd);
            // Se selecciona el nuevo elemento
            Xsel--;
            // Se escribe la nueva selección
            drawSelection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11, lcd);
        }
        // transmit work screen to physical screen:
        lcd->Flush();
    }
}

// El botón 3 desplaza la selección al elemento derecho al actual
void Teclado::button3pressed(DogMLCD* lcd){
    // Si sales de los elementos seleccionables no se cambia de selección
    if((Xsel + 1) < COLUMNASMATRIZ){
        // Si se está en la última fila
        if(Ysel == (FILASMATRIZ-1) ){
            // Se se venía de la tecla mayus
            if(m[Ysel][Xsel] == MAYUS){
                drawDeselection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11-1, lcd);
                seleccionarBarraEspaciadora(lcd);
                // Se mueven un elemento a la derecha
                Xsel++;
            }else if(m[Ysel][Xsel] == SPACEBAR){    //si se venía de la barra espaciadora
                deseleccionarBarraEspaciadora(lcd);
                // Se mueve la selección al penultimo elemento
                Xsel = 9;
                // Se escribe la nueva selección (la selección es CARACTER11-1 por razones de espacio) (tecla mayus)
                seleccionarAplicar(lcd);
            }
        }else{            
            // Se borra la selección anterior
            drawDeselection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11, lcd);
            // Se selecciona el nuevo elemento
            Xsel++;
            // Se escribe la nueva selección
            drawSelection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11, lcd);
        }
        
        // transmit work screen to physical screen:
        lcd->Flush();
    }
}

// El botón 4 baja la selección al elemento superior al actual
void Teclado::button4pressed(DogMLCD* lcd){
    // Si sales de los elementos seleccionables no se cambia de selección
    if((Ysel + 1) < FILASMATRIZ){
        // Se borra la selección anterior
        drawDeselection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11, lcd);
        // Se selecciona el nuevo elemento
        Ysel++;
        
        // Si la siguiente fila es la última (teclas especiales)
        if(Ysel == (FILASMATRIZ-1) ){
            // Se guarda la última tecla que estaba seleccionada
            lastXsel = Xsel;
            lastYsel = Ysel-1;          
            // Si se va hacia la barra espaciadora se selecciona esta
            if(m[Ysel][Xsel] == SPACEBAR){
                seleccionarBarraEspaciadora(lcd);
            }else if(m[Ysel][Xsel] == APLICAR){ // Si se va hacia la tecla aplicar se selecciona esta
                seleccionarAplicar(lcd);
            }else{
                // Se escribe la nueva selección (la selección es CARACTER11-1 por razones de espacio) (tecla mayus)
                drawSelection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11-1, lcd);
            }
        }else{
            // Se escribe la nueva selección
            drawSelection(OFFSETX-2 + Xsel*CARACTER11, WRITTENSPACE + Ysel*CARACTER11, CARACTER11, CARACTER11, lcd);
        }
        
        // transmit work screen to physical screen:
        lcd->Flush();
    }
}

char *Teclado::getNombre(){
    return nombre;
}

// Esta función guarda la pantalla a la que se debe volver en caso de ser pulsado el boton atras
void Teclado::setNextScreen(char nameScreen[NCARSCREEN]){
    strcpy(nameNextScreen, nameScreen);
}

void Teclado::asignarMinusculas(){
    // Primera fila
    m[0][0] = 'q';
    m[0][1] = 'w';     
    m[0][2] = 'e';
    m[0][3] = 'r';
    m[0][4] = 't';
    m[0][5] = 'y';
    m[0][6] = 'u';     
    m[0][7] = 'i';
    m[0][8] = 'o';
    m[0][9] = 'p';
    m[0][10] = '(';
    
    // Segunda fila
    m[1][0] = 'a';
    m[1][1] = 's';     
    m[1][2] = 'd';
    m[1][3] = 'f';
    m[1][4] = 'g';
    m[1][5] = 'h';
    m[1][6] = 'j';     
    m[1][7] = 'k';
    m[1][8] = 'l';
    m[1][9] = 164;
    m[1][10] = ')';
    
    // Tercera fila
    m[2][0] = 'z';
    m[2][1] = 'x';     
    m[2][2] = 'c';
    m[2][3] = 'v';
    m[2][4] = 'b';
    m[2][5] = 'n';
    m[2][6] = 'm';     
    m[2][7] = ',';
    m[2][8] = '.';
    m[2][9] = ';';
    m[2][10] = '_';
    
    // Cuarta fila
    m[3][0] = '1';
    m[3][1] = '2';     
    m[3][2] = '3';
    m[3][3] = '4';
    m[3][4] = '5';
    m[3][5] = '6';
    m[3][6] = '7';     
    m[3][7] = '8';
    m[3][8] = '9';
    m[3][9] = '0';
    m[3][10] = BACK;
    
    // Quinta fila
    m[4][0] = MAYUS;
    m[4][1] = SPACEBAR;
    m[4][2] = SPACEBAR;
    m[4][3] = SPACEBAR;
    m[4][4] = SPACEBAR;
    m[4][5] = SPACEBAR;
    m[4][6] = SPACEBAR;     
    m[4][7] = SPACEBAR;
    m[4][8] = SPACEBAR;
    m[4][9] = APLICAR;
    m[4][10] = APLICAR;
}

void Teclado::asignarMayusculas(){
    // Primera fila
    m[0][0] = 'Q';
    m[0][1] = 'W';     
    m[0][2] = 'E';
    m[0][3] = 'R';
    m[0][4] = 'T';
    m[0][5] = 'Y';
    m[0][6] = 'U';     
    m[0][7] = 'I';
    m[0][8] = 'O';
    m[0][9] = 'P';
    m[0][10] = '(';
    
    // Segunda fila
    m[1][0] = 'A';
    m[1][1] = 'S';     
    m[1][2] = 'D';
    m[1][3] = 'F';
    m[1][4] = 'G';
    m[1][5] = 'H';
    m[1][6] = 'J';     
    m[1][7] = 'K';
    m[1][8] = 'L';
    m[1][9] = 165;
    m[1][10] = ')';
    
    // Tercera fila
    m[2][0] = 'Z';
    m[2][1] = 'X';     
    m[2][2] = 'C';
    m[2][3] = 'V';
    m[2][4] = 'B';
    m[2][5] = 'N';
    m[2][6] = 'M';     
    m[2][7] = ',';
    m[2][8] = '.';
    m[2][9] = ';';
    m[2][10] = '_';
    
    // Cuarta fila
    m[3][0] = '1';
    m[3][1] = '2';     
    m[3][2] = '3';
    m[3][3] = '4';
    m[3][4] = '5';
    m[3][5] = '6';
    m[3][6] = '7';     
    m[3][7] = '8';
    m[3][8] = '9';
    m[3][9] = '0';
    m[3][10] = BACK;
    
    // Quinta fila
    m[4][0] = MAYUS;
    m[4][1] = SPACEBAR;
    m[4][2] = SPACEBAR;
    m[4][3] = SPACEBAR;
    m[4][4] = SPACEBAR;
    m[4][5] = SPACEBAR;
    m[4][6] = SPACEBAR;     
    m[4][7] = SPACEBAR;
    m[4][8] = SPACEBAR;
    m[4][9] = APLICAR;
    m[4][10] = APLICAR;
}