/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef MENU_H
#define MENU_H

#include "Seleccion.h"
#include "doggy.h"


#define SEMIHEIGHTFONT 5    // La mitad de la altura de un caracter
#define MAXCARACTER 22      // Número máximo de caracteres de cada elemento
#define HEIGHTCARACTER 11     // Anchura de un caracter de media
#define MAXLINES 5            // Número máximo de filas (cada fila es un elemento)
#define OFFSETX 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres
#define OFFSETY 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres en la parte superior

// EL menu es una lista de selección con los elementos equiespeciados, no centrados en la esquina superior izquierda
// como en una lista de selección normal. Además el texto es de tamaño 11.
class Menu : public Seleccion {
    public:
    virtual void initialize(DogMLCD* lcd);
    int addElement(char text[], char nameNextScreen[NCARSCREEN]);
    
    virtual void button1pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón superior es pulsado, definirla para añadir funcionalidades
    virtual void button4pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón inferior es pulsado, definirla para añadir funcionalidades
    virtual void button5pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón central es pulsado, definirla para añadir funcionalidades  
        
    private:
    char list[MAXLINES][MAXCARACTER];      // Lista con las opciones del menu. Pueden ser com máximo 5 con una longitud máxima de 24 caracteres
    int posElement[5][3];           // Guarda las posición y tamaños de cada elemento (0 = posx, 1 = posy, 2 = ancho)
    char nextScreenID[5][NCARSCREEN];
    
    // Devuelve el ancho del elemento
    // Para ello lo recorre sumando los pixeles que ocupa cada caracter
    int widthElement(int element, DogMLCD* lcd);       
};

#endif