/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef MENSAJE_H
#define MENSAJE_H

#include "Seleccion.h"
#include "doggy.h"

#define SEMIHEIGHTFONT 5    // La mitad de la altura de un caracter
#define MAXCARACTER 28      // Número máximo de caracteres de cada elemento
#define HEIGHTCARACTER 11     // Anchura de un caracter de media
#define MAXLINES 5            // Número máximo de filas (cada fila es un elemento)
#define OFFSETX 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres

// EL menu es una lista de selección con los elementos equiespeciados, no centrados en la esquina superior izquierda
// como en una lista de selección normal. Además el texto es de tamaño 11.
class Mensaje : public Seleccion {
    public:
    Mensaje(char nextScreen[], char newAdvice[]);
    
    void setNextScreen(char nameScreen[NCARSCREEN]);
    
    virtual void initialize(DogMLCD* lcd);
    int addElement(char text[]);
    
    virtual void button5pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón central es pulsado, definirla para añadir funcionalidades  
        
    private:
    char list[MAXLINES][MAXCARACTER];      // Lista con las opciones del menu. Pueden ser com máximo 5 con una longitud máxima de 24 caracteres
    int posElement[MAXLINES][3];           // Guarda las posición y tamaños de cada elemento (0 = posx, 1 = posy, 2 = ancho)
    char nextScreenID[NCARSCREEN];
    char advice[MAXCARACTER];
    
    // Devuelve el ancho del elemento
    // Para ello lo recorre sumando los pixeles que ocupa cada caracter
    int widthElement(int element, DogMLCD* lcd);       
};

#endif