#include "mbed.h"
#include "Mensaje.h"

extern ScreenManager SC;
extern DigitalIn boton5;

Mensaje::Mensaje(char nextScreen[], char newAdvice[]){
    strcpy(nextScreenID, nextScreen);
    strcpy(advice, newAdvice);
}

void Mensaje::setNextScreen(char nameScreen[NCARSCREEN]){
    strcpy(nextScreenID, nameScreen);
}
    
void Mensaje::initialize(DogMLCD* lcd){   

    // select font to use:
    lcd->XFont = xfont_11;
    
    // Para pintar los elementos del menú primero
    // se calcula la posición del primer elemento y el offset hasta el siguiente elemento (eje vertical)
    int offset  = HEIGHT/(nElementos + 1);
    int posy0 = offset - SEMIHEIGHTFONT;
    
    // Se pintan los elementos del menu con dos particularidades:
    // - El elemento seleccionado se pinta "seleccionado"
    // - Los elementos se pintan centrados
    
    for(int i = 0; i < nElementos; i++){
        posElement[i][2] = widthElement(i, lcd);
        posElement[i][0] = (WIDTH - posElement[i][2])/2;
        posElement[i][1] = offset*(i) + posy0;;
        lcd->XString(posElement[i][0], posElement[i][1], list[i]);
    }
    
    // select font to use:
    lcd->XFont = xfont_8;
    
    // Se escribe el consejo en la parte inferior de la pantalla
    lcd->XString(OFFSETX, HEIGHT - 8, advice);
    
    // transmit work screen to physical screen:
    lcd->Flush();
}

// El botón 5 envía a la pantalla correspondiente según el elemento seleccionado
void Mensaje::button5pressed(DogMLCD* lcd){
    SC.changeScreen(nextScreenID);
}

// Añade un elemento al menu con el texto especificado en el primer argumento
// cada elemento nos enviará a la pantalla con el identificador del segundo argumento
// Devuelve el identificador del elemento añadido
int Mensaje::addElement(char text[]){
    strcpy(list[nElementos], text);
    nElementos++;
    return nElementos - 1;
}


// Devuelve el ancho del elemento
// Para ello lo recorre sumando los pixeles que ocupa cada caracter
int Mensaje::widthElement(int element, DogMLCD* lcd){
    int width = 0;
    for(int i = 0; i < (strlen(list[element])); i++){
        width += lcd->GetGlyph(list[element][i]).wid + 1;
    }
    return width;
}
