#include "mbed.h"
#include "ListaSelec.h"

extern ScreenManager SC;

extern DigitalIn boton1;
extern DigitalIn boton4;
extern DigitalIn boton5;

void ListaSelec::DrawElements(DogMLCD* lcd){
    for(int i = 0; i < SCREENLINES; i++){
        if((i + topElement) < nElementos){
            lcd->XString(OFFSETX, HEIGHTCARACTER8*i + 1 + OFFSETY, list[i + topElement]);
        }
    }
    drawSelection(OFFSETX-1, HEIGHTCARACTER8*posMark + OFFSETY, WIDTH-OFFSETX, HEIGHTCARACTER8, lcd);
}
   
void ListaSelec::initialize(DogMLCD* lcd){
    // Se inicializa la selección
    setSelect(0);
    topElement = 0;
    posMark = 0;
    lastPosMark = 0;
    
    // select font to use:
    lcd->XFont = xfont_8;
    
    // Se pintan los elementos de la lista
    DrawElements(lcd);
          
    // transmit work screen to physical screen:
    lcd->Flush();
}

// El botón 1 sube la selección al elemento superior al actual
void ListaSelec::button1pressed(DogMLCD* lcd){
    // Si sales de los elementos seleccionables no se cambia de selección
    if((getSelect()-1) >= 0){
        // Se selecciona el elemento
        setSelect(getSelect()-1);
        // Si se ha seleccionado un elemento superior que no está siendo mostrado en la pantalla
        if(getSelect() < topElement){
            // Se sube hacia arriba el top element (se le resta 1) y se pintan de nuevo los elementos de pantalla
            topElement--;
            lcd->Clear();
            DrawElements(lcd);
        }else{
            // Sino se mueve el marcador de selección        
            lastPosMark = posMark;
            posMark--;    
            drawDeselection(OFFSETX-1, HEIGHTCARACTER8*lastPosMark + OFFSETY, WIDTH-OFFSETX , HEIGHTCARACTER8, lcd);
            drawSelection(OFFSETX-1, HEIGHTCARACTER8*posMark + OFFSETY, WIDTH-OFFSETX, HEIGHTCARACTER8, lcd);
        }
        // transmit work screen to physical screen:
        lcd->Flush();
    }
}

// El botón 4 baja la selección al elemento superior al actual
void ListaSelec::button4pressed(DogMLCD* lcd){
    // Si sales de los elementos seleccionables no se cambia de selección
    if((getSelect()+1) <= (nElementos - 1)){
        // Se selecciona el elemento
        setSelect(getSelect()+1);
        // Si se ha seleccionado un elemento inferior que no está siendo mostrado en la pantalla
        if(getSelect() > (topElement + SCREENLINES - 1)){
            lcd->Clear();           
            topElement++;
            DrawElements(lcd);
        }else{
            // Sino se mueve el marcador de selección     
            lastPosMark = posMark;
            posMark++;   
            drawDeselection(OFFSETX-1, HEIGHTCARACTER8*lastPosMark + OFFSETY, WIDTH-OFFSETX, HEIGHTCARACTER8, lcd);
            drawSelection(OFFSETX-1, HEIGHTCARACTER8*posMark + OFFSETY, WIDTH-OFFSETX, HEIGHTCARACTER8, lcd);
        }
        // transmit work screen to physical screen:
        lcd->Flush();
    }
}

    // El botón 5 envía a la pantalla correspondiente según el elemento seleccionado
void ListaSelec::button5pressed(DogMLCD* lcd){
    SC.changeScreen(nextScreenID[getSelect()]);
}

// Añade un elemento al menu con el texto especificado en el primer argumento
// cada elemento nos enviará a la pantalla con el identificador del segundo argumento
// Devuelve el identificador del elemento añadido
int ListaSelec::addElement(char text[], char nameNextScreen[NCARSCREEN]){
    //strcpy(list[nElementos], text);
    list[nElementos] = text;
    //strcpy(nextScreenID[nElementos], nameNextScreen);
    nextScreenID[nElementos] = nameNextScreen;
    nElementos++;
    return nElementos - 1;
}

char *ListaSelec::getElement(int index){
    return list[index];
}