/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef ACCELRAM_H
#define ACCELRAM_H

#include "MultipleRAM.h"

#define BYTESPAQUETE 6

// Clase que gestiona el uso de ultiples RAMs como si fueran una sola de mayor tamaño. Esta clase esta diseñada para guardar paquetes de
// 3 datos de 2 bytes (conteniendo 6 byte en total cada paquete)

class AccelRAM : public MultipleRAM{
    public:
    AccelRAM(SPI spi);
    
    void putData(int16_t data[]);   // Escribe en la siguiente posición el nuevo dato
    int16_t readData();             // Lee un nuevo de dato de la siguiente posición
    
    void putData(int address, int16_t data[]);      // Escribe un paquete (dato) en la posición de memoria segun paquetes especificada
    int readData(int address, int16_t data[]);                  // Lee un paquete (dato) en la posición de memoria segun paquetes especificada
    
    unsigned int getMaxAddressPaquetes();           // Posición máxima de memoria (según número de paquetes)
    
    private:    
    unsigned int maxAddressPaquetes;    // Posición máxima de memoria (según número de paquetes)
    unsigned int lastWriteAddress;   // Última posición de memoria en la que se ha escrito (en bytes)
    unsigned int lastReadAddress;   // Última posición de memoria de la que se ha leído (en bytes)
    char lastData[BYTESPAQUETE];   // Último paquete escrito o leído
    
};

#endif