/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#include "AccelRAM.h"

AccelRAM::AccelRAM(SPI spi) : MultipleRAM(spi) {
    lastWriteAddress = 0;
    lastReadAddress = 0;
    
    maxAddressPaquetes = (getMaxAddress()+1)/BYTESPAQUETE - 1;
    
}

void AccelRAM::putData(int16_t data[]){   // Escribe en la siguiente posición el nuevo dato
}

int16_t AccelRAM::readData(){             // Lee un nuevo de dato de la siguiente posición
}

void AccelRAM::putData(int address, int16_t data[]){      // Escribe un paquete (dato) en la posición de memoria segun paquetes especificada
    // Se calcula la primera posición de memoria de los 6 bytes a escribir
    lastWriteAddress = address*BYTESPAQUETE;
    
    // Se prepara el paquete a enviar (Primero se envían los bytes más significativos)
    // Aceleración X
    lastData[1] = data[0];   // Byte menos significativo
    data[0] >>= 8;
    lastData[0] = data[0];   // Byte más significativo
    // Aceleración Y
    lastData[3] = data[1];   // Byte menos significativo
    data[1] >>= 8;
    lastData[2] = data[1];   // Byte más significativo
    // Aceleración Z
    lastData[5] = data[2];   // Byte menos significativo
    data[2] >>= 8;
    lastData[4] = data[2];   // Byte más significativo
      
    // Se envía escribe todo el paquete en la RAM (múltiple) en la posición de memoria calculada
    //writeBytes(lastWriteAddress, lastData, BYTESPAQUETE);
      
    // Se envñian uno a uno todos los bytes del paquete
    writeBytes(lastWriteAddress, &lastData[0], 1);
    writeBytes(lastWriteAddress+1, &lastData[1], 1);
    writeBytes(lastWriteAddress+2, &lastData[2], 1);
    writeBytes(lastWriteAddress+3, &lastData[3], 1);
    writeBytes(lastWriteAddress+4, &lastData[4], 1);
    writeBytes(lastWriteAddress+5, &lastData[5], 1);
}

int AccelRAM::readData(int address, int16_t data[]){                  // Lee un paquete (dato) en la posición de memoria segun paquetes especificada
    // Se calcula la primera posición de memoria de los 6 bytes a leer
    lastReadAddress = address*BYTESPAQUETE;
    
    // Se leen los bytes
    //readBytes(lastReadAddress, lastData, BYTESPAQUETE);
    
    // Se leen uno a uno los bytes
    readBytes(lastReadAddress, &lastData[0], 1);
    readBytes(lastReadAddress+1, &lastData[1], 1);
    readBytes(lastReadAddress+2, &lastData[2], 1);
    readBytes(lastReadAddress+3, &lastData[3], 1);
    readBytes(lastReadAddress+4, &lastData[4], 1);
    readBytes(lastReadAddress+5, &lastData[5], 1);
    
    // Se reconstruye el paquete(Primero se leen los bytes más significativos)
    // Aceleración X
    data[0] = lastData[0];   // Byte más significativo
    data[0] <<= 8;
    data[0] += lastData[1];   // Byte menos significativo
    
    // Aceleración Y
    data[1] = lastData[2];   // Byte más significativo
    data[1] <<= 8;
    data[1] += lastData[3];   // Byte menos significativo
    
    // Aceleración Z
    data[2] = lastData[4];   // Byte más significativo
    data[2] <<= 8;
    data[2] += lastData[5];   // Byte menos significativo
    
    return 0;
    
}

unsigned int AccelRAM::getMaxAddressPaquetes(){
    return maxAddressPaquetes;
}
