/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#include "OpcionesViaje.h"

extern ScreenManager SC;
extern SistemaArchivos SA;
extern Teclado keyboard;
extern GuardarOtroNombre guardadoCorrect;
extern GuardarOtroNombre guardadoCorrectEN;

void OpcionesViaje::button5pressed(DogMLCD* lcd){
    bool llamarRaiz = true;     // Se usa para llamar o no a la función padre (para controlar los cambios de pantalla)
    // Se cambia el idioma actual y se guarda tambien en el fichero de configuracion
    switch(getSelect()){
        // Cambiar nombre
        case 0:
            guardadoCorrect.setNextScreen("listadoViajes");
            guardadoCorrectEN.setNextScreen("listadoViajes");
            guardadoCorrect.setBackScreen("listadoViajes");
            guardadoCorrectEN.setBackScreen("listadoViajes");
            guardadoCorrect.setNombreAntiguo(nombreViaje);
            guardadoCorrectEN.setNombreAntiguo(nombreViaje);
            keyboard.setBackScreen("rOptions");
            keyboard.setNextScreen("fileSaved");       
            break;
        // Borrar viaje    
        case 1:
            llamarRaiz = false;    
            
            if(SA.deleteRide(nombreViaje)){  // Si no se pudo borrar se avisa por pantalla de USB 
                SC.changeScreen("USBdesconectado");
            }else{
                SC.changeScreen("archivoBorrado");
            }
            break;            
    }
    if(llamarRaiz){
        Menu::button5pressed(lcd);
    }
}

void OpcionesViaje::setViaje(char *nombre){
    nombreViaje = nombre;
}