/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#include "GuardarOtroNombre.h"

extern FechaHora FH;
extern ScreenManager SC;
extern SistemaArchivos SA;
extern MSCFileSystem msc;
extern Teclado keyboard;

extern Mensaje guardadoCorrect;
extern Mensaje guardadoCorrectEN;

extern Mensaje nombreExistente;
extern Mensaje nombreExistenteEN;

GuardarOtroNombre::GuardarOtroNombre(char nextScreen[], char newAdvice[], char newWaitMsg[]):Mensaje(nextScreen, newAdvice){
    nombreAntiguo = NULL;
    strcpy(waitMsg, newWaitMsg);
}

void GuardarOtroNombre::setNombreAntiguo(char *oldName){
    nombreAntiguo = oldName;
}

void GuardarOtroNombre::disableNombreAntiguo(){
    nombreAntiguo = NULL;
}

void GuardarOtroNombre::initialize(DogMLCD* lcd){
    // select font to use:
    lcd->XFont = xfont_11;  
    // Se pinta un mensaje de espera
    lcd->XString(OFFSETX + 8, 23, waitMsg);
    // Se envía a la pantalla física
    lcd->Flush();
    // Se deja la pantalla en blanco para cuando se acabe de cambair de nombre el archivo
    lcd->Clear();
    
    // Se cambia el nombre del archivo del propio USB    
    char oldFile[64];
    char newName[64];
    char aux[64];
    
    // Si el nombreAntiguo vale NULL se toma como nombre antiguo la última fecha y hora guardado    
    if(nombreAntiguo == NULL){
        strcpy(aux, FH.getFechaHora());
        strcpy(oldFile, "/usb/RAW");
        strcat(oldFile, aux);
        strcat(oldFile, ".txt");
    }else{
        strcpy(oldFile, "/usb/");
        strcat(oldFile, nombreAntiguo);
        strcat(oldFile, ".txt");
    }
    
    // Si el archivo no se puede cargar se pasa a la pantalla que avisa que el USB está lleno o desconectado    
    FILE* file;
    file = fopen(oldFile, "r");
    if(file == NULL){
        SC.changeScreen("USBdesconectado");        
    }else{
        // Se cierra el archivo
        fclose(file);
        // El nombre nuevo se toma de el texto introducido con el teclado
        strcpy(aux, keyboard.getNombre());
        // Se comprueba si ya existe un fichero con este nombre
        if(SA.alredyExist(aux)){
            // Se configura la pantalla siguiente según si se está guardan un viaje nuevo con otro nombre o se está cambiando el nombre a uno ya existente
            if(nombreAntiguo != NULL){  // Se debe de volver a la pantalla de opciones del viaje
                nombreExistente.setNextScreen("rOptions");
                nombreExistente.setBackScreen("rOptions");
                nombreExistenteEN.setNextScreen("rOptions");
                nombreExistenteEN.setBackScreen("rOptions");
            }else{                  // Se debe volver a la pantalla de guardado de nuevo viaje
                nombreExistente.setNextScreen("guardaViaje");
                nombreExistente.setBackScreen("guardaViaje");
                nombreExistenteEN.setNextScreen("guardaViaje");
                nombreExistenteEN.setBackScreen("guardaViaje");
            }
            SC.changeScreen("alredyExist");                      
        }else{        
            // Se va a guardar cno otro nombre el archivo asi que
            if(nombreAntiguo != NULL){
                SA.renameRide(nombreAntiguo, aux);            
            }else{  // Se guarda el nuevo nombre del archivo en la lista de nombres de los viajes sólo si nombreAntiguo vale NULL
                strcpy(newName, "/usb/");
                strcat(newName, aux);
                strcat(newName, ".txt");
                SA.file_rename(oldFile, newName);
                strcpy(newName, keyboard.getNombre());
                SA.addElement(newName);
            }
            
            // Se muestra el mensaje de archivo guardado correctamente por pantalla
            Mensaje::initialize(lcd);
        }
    }
}

void GuardarOtroNombre::button5pressed(DogMLCD* lcd){    
    Mensaje::button5pressed(lcd);    
}