/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef AUTOCALIBRACION_H
#define AUTOCALIBRACION_H

#include "mbed.h"
#include "SistemaArchivos.h"
#include "ScreenManager.h"
#include "MSCFileSystem.h"
#include "Configuracion.h"
#include "KXR94.h"
#include "Buffering.h"
#include <stdlib.h>
#include "ParametrosCalibracion.h"

#define MAXCAR 32
#define OFFSETX 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres
#define OFFSETY 2            // Espacio en pixeles que se deja antes de escribir una linea de caracteres en la parte superior
#define OFFSETMSG 12

#define OFFSETTIEMPO 2       // Tiempo que se espera desde que se pulsa el botón OK hasta que se comienza a tomar medidas (en segundos)
#define NDATOSPASO 1000      // Número de datos que se leerán en cada paso para hacer las medias
#define USENTREDATOS 1000         // Tiempo entre la lectura de cada dato en microsegundos       

#define ACELGRAVEDAD 9.81

class AutoCalibracion : public Screen {
    public:
        virtual void initialize(DogMLCD* lcd);
        virtual void update(DogMLCD* lcd);
    
    private:    
        bool pulsado5;
        bool pulsado6;
        bool leyendoDatos;      // Indica si el viaje está o no en proceso
        
        char pasoCalibracion;       // Paso actual de los 7 pasos para calibrar el dispositivo
        
        int readings[3]; //Lectura aceleraciones sensor digital
        float mediaXpos, mediaYpos, mediaZpos, mediaXneg, mediaYneg, mediaZneg;   //  Variables que guardan las medias medidas en cada paso
        int datosCapturados;    // Numero de datos que se han leído en cada paso
        float mediaAux;   // En esta variable se va calculando la media a medida que llegan los datos
        
        float aXr, aYr, aZr;            //Tiempo y medidas de aceleracion leidos del buffer
        //unsigned int contDatos;     //Contador de datos
        unsigned int ContadorDatos;
        
        Ticker tickerLectura;       
        void LeeAcelerometro();
};

#endif
