/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef ARCHIVOGUARDADO_H
#define ARCHIVOGUARDADO_H

#include "Seleccion.h"
#include "FechaHora.h"
#include "doggy.h"

#define MAXCARACTER 22      // Número máximo de caracteres de cada elemento
#define OFFSETX 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres
#define OFFSETXTITLES 16            // Espacio en pixeles que se deja antes de escribir una linea de caracteres
#define OFFSETY 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres

// Lista de elementos seleccionables. Tamaño de caracteres 8. 
class ArchivoGuardado: public Seleccion{
    public:
    ArchivoGuardado(char nextScreen[], char newAdvice[], char newnameTitle[], char newdateTitle[], char newtimeTitle[]);
    virtual void initialize(DogMLCD* lcd);
    
    virtual void button5pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón central es pulsado, definirla para añadir funcionalidades  
    
    void setName(char newName[]);
    void setDate(char newDate[]);
    void setTime(char newTime[]);
    
    private:    
    char nextScreenID[NCARSCREEN];
    char advice[MAXCARACTER + 10];
    char nameTitle[MAXCARACTER];
    char dateTitle[MAXCARACTER];
    char timeTitle[MAXCARACTER];
    

};

#endif