/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef SISTEMAARCHIVOS_H
#define SISTEMAARCHIVOS_H

#define NMAXVIAJES 100
#define NCARACTERES 28
#define NCARACTERESLECTURA 64

#include "mbed.h"
#include "ScreenManager.h"
#include "MSCFileSystem.h"
#include "SelecManager.h"
#include <string.h>
#include <stdlib.h>

// Esta clase va a gestionar los archivos que guardan los datos recogidos del acelerómetro
// La filosofía de funcionamiento es la siguiente:
// En la memoria flash externa se guardarán los archivos con los datos
// Como se va a necesitar cargar estos archivos en otro momento o incluso cambiarles el nombre, se guardará en la memoria flash de la mbed una lista con los nombres de los archivosde datos y así independientemente de su nombre 
// puedan encontrarse y cargarse.
// En definitiva esta clase controlará esta lista de nombres de archivos
class SistemaArchivos{
    public:
    SistemaArchivos();    // EL construtor carga los valores de configuracion o crea una configuracion inicial en caso de no existir
    
    void addElement(char newElement[]);  // Esta función añade un nuevo nombre de archivo a la lista
    
    int reloadRideNames();             // Esta función carga en memoria los nombres de los viajes guardados en el archivo RideList.txt y guarda el número de viajes
                                        // Devuelve 0 si se recargo correctamente o 1 si no se pudo acceder al archivo de la lista de viajes.
    char *getNameRide(int nameNumber);               // Esta función devuelve un puntero a la lista de nombres de los viajes
    int getNrides();
    
    bool alredyExist(char *name);       // Comprueba si nombre pasado como argumento está o no en la lista de nombres de los viajes
    
    int file_rename(const char *oldfile, const char *newfile);  // Cambia el nombre de un archivo de la memoria flash
    
    // Funciones para modificar la lista de viajes: "RideList.txt", antes de usar estas funciones
    // llamar a la función "reloadRideNames() para actualizar la lista de viajes en memoria
    // También modifican los archivos en la memoria flash
    // Estas funciones devuelven 0 en caso de haber podido ejecutarse correctamente o 1 en caso de error    
    int deleteRide(char *fileName);   // Borra los archivos asociados a un viaje, y lo borra de la lista de viajes    
    int renameRide(char *fileName, char *newName);   // Cambia el nombre de los archivos asociados a un viaje, y de la lista de viajes    
    
    
    private:
    
    char names[NMAXVIAJES][NCARACTERES];
    
    void saveRideList();     // Guarda en el archivo "RideList.txt" la lista de nombres guardados en el array names sobreescribiendo los anteriores
                            // Devuelve 1 si no se ha podido acceder al archivo
    
    int nViajes;
    
    void deleteLastChar(char *str);     // Borra el último caracter de una cadena
};


#endif