#include "SistemaArchivos.h"

extern ScreenManager SC;
extern MSCFileSystem msc;

SistemaArchivos::SistemaArchivos(){
    nViajes = 0;
}

void SistemaArchivos::addElement(char newElement[]){
    FILE* file = fopen("/local/RideList.vme","a");
    fprintf(file, "%s\n", newElement);
    fclose(file);
}

int SistemaArchivos::reloadRideNames(){
    // Se reinicia el número de viajes
    nViajes = 0;
    // Se abre el archivo de nombres de viajes
    FILE* file = fopen("/local/RideList.vme","r");
    if(file == NULL){
        return 1;
    }else{
        while(!feof(file)){ // Mientras no se haya llegado al fin de fichero
            //strcpy(names[nViajes], readTextLine(file));
            fgets(names[nViajes], NCARACTERES, file);
            // Se borra el último caracter de la cadena, el caracter '\n'
            deleteLastChar(names[nViajes]);
            //fscanf(file, "%s", names[nViajes]);
            nViajes++;
        }
        // La última cadena es '\n', esta no se contara como cadena
        nViajes--;
        fclose(file);
        return 0;
    }
}

int SistemaArchivos::deleteRide(char *fileName){   // Borra los archivos asociados a un viaje, y lo borra de la lista de viajes
    char file[64]; 

    // Primero se intenta borrar el archivo de la memoria flash
    strcpy(file, "/usb/");
    strcat(file, fileName);
    strcat(file, ".txt"); 
    
    if(remove(file) != 0){  // Si no se pudo borrar se devuelve un 1
        return 1;
    }else{      // Si se borró el archivo se borra también de la lista de viajes
        // Para ello primero se borra el viaje del array "names"
        // Procedimiento:
        // - Se busca el nombre en la lista
        // - Una vez encontrada su posición todos los elementos por debajo de este se suben una posición
        int pos = 0;      
        
        // - Se busca el nombre en la lista
        while(strcmp(names[pos], fileName)){
            pos++;
        }
        
        // En este momento la variable "pos" guarda la posición de memoria de el elemento a borrar
        // Se aumenta en uno este índice para subir de posición los elementos por debajo de este
        pos++;
        
        // - Una vez encontrada su posición todos los elementos por debajo de este se suben una posición
        for (int i = pos; i < nViajes; i++){ 
            strcpy(names[i-1], names[i]);
        }
        
        // El número de viajes es una unidad menor
        nViajes--;
        
        // Se guarda la nueva lista de viajes
        saveRideList();
        
        return 0;
    }
}

int SistemaArchivos::renameRide(char *fileName, char *newName){   // Cambia el nombre de los archivos asociados a un viaje, y de la lista de viajes
    char oldFile[64]; 
    char newFile[64];

    // Primero se intenta cambiar el nombre del archivo de la memoria flash
    strcpy(oldFile, "/usb/");
    strcat(oldFile, fileName);
    strcat(oldFile, ".txt"); 
    
    strcpy(newFile, "/usb/");
    strcat(newFile, newName);
    strcat(newFile, ".txt"); 
    
    if(file_rename(oldFile, newFile) != 0){  // Si no se pudo borrar se devuelve un 1
        return 1;
    }else{      // Si se cambió el nombre del archivo también se cambia el nombre en la lista de viajes
        // Procedimiento:
        // - Se busca el nombre antiguo en la lista
        // - Una vez encontrada su posición se cambia su nombre
        int pos = 0;      
        
        // - Se busca el nombre antiguo en la lista
        while(strcmp(names[pos], fileName)){
            pos++;
        }
        
        // - Una vez encontrada su posición se cambia su nombre
        strcpy(names[pos], newName);
        
        // Se guarda la nueva lista de viajes
        saveRideList();
        
        return 0;
    }
}

bool SistemaArchivos::alredyExist(char *name){
    bool value = false;
    for(int i = 0; i < nViajes; i++){
        if(!strcmp(names[i], name)){
            value = true;
        }
    }
    return value;
}

void SistemaArchivos::saveRideList(){
    // Se sobreescribe el archivo "RideList.vme" con la lista de el array nombres
    FILE* file = fopen("/local/RideList.vme","w");
    for(int i = 0; i < nViajes; i++){
        fprintf(file, "%s\n", names[i]);
    }   
    fclose(file);
}    

char* SistemaArchivos::getNameRide(int nameNumber){
    return names[nameNumber];    
}

int SistemaArchivos::getNrides(){
    return nViajes;
}

//***********************************************************
// file_rename: renames a file.
//    Kind of hoakey as it moves data instead of adjusting
//    the file name in the directory. 
//    Checks to insure the file was renamed.
//    Returns -1 = error; 0 = success
//***********************************************************
int SistemaArchivos::file_rename(const char *oldfile, const char *newfile) {
    int retval = 0;
    int ch;
 
    FILE *fpold = fopen(oldfile, "r");
    if(fpold == NULL) {
        retval = (-1);
    }else{ 
        FILE *fpnew = fopen(newfile, "w");
        
        while (1) {  
            ch = fgetc(fpold); 
            if (ch == EOF) break;
            fputc(ch, fpnew);  
        }
        
        fclose(fpnew);
        fclose(fpold);
     
        fpnew = fopen(newfile, "r");
        if(fpnew == NULL) {
            retval = (-1);
        } 
        else {
            remove(oldfile);
        }
        fclose(fpnew);
    }
    return (retval);
}

void SistemaArchivos::deleteLastChar(char *str){     // Borra el último caracter de una cadena
    str[strlen(str)-1] = '\0';
}
    