#include "mbed.h"
#include "Menu.h"

extern ScreenManager SC;

extern DigitalIn boton1;
extern DigitalIn boton4;
extern DigitalIn boton5;
    
void Menu::initialize(DogMLCD* lcd){
    // Se inicializa la selección
    setSelect(0);
    
    // select font to use:
    lcd->XFont = xfont_11;
    
    // Para pintar los elementos del menú primero
    // se calcula la posición del primer elemento y el offset hasta el siguiente elemento (eje vertical)
    int offset  = HEIGHT/(nElementos + 1);
    int posy0 = offset - SEMIHEIGHTFONT;
    
    // Se pintan los elementos del menu con dos particularidades:
    // - El elemento seleccionado se pinta "seleccionado"
    // - Los elementos se pintan centrados
    
    for(int i = 0; i < nElementos; i++){
        posElement[i][2] = widthElement(i, lcd);
        posElement[i][0] = (WIDTH - posElement[i][2])/2;
        posElement[i][1] = offset*(i) + posy0;;
        lcd->XString(posElement[i][0], posElement[i][1], list[i]);
        // Si el elemento está seleccionado se marca con la forma de selección correspondiente
        if(i == getSelect()){
            drawSelection(posElement[i][0]-2, posElement[i][1]-1, posElement[i][2]+2, HEIGHTCARACTER+2, lcd);
        }
    }
    
    // transmit work screen to physical screen:
    lcd->Flush();
}

// El botón 1 sube la selección al elemento superior al actual
void Menu::button1pressed(DogMLCD* lcd){
    // Si sales de los elementos seleccionables no se cambia de selección
    if((getSelect()-1) >= 0){
        setSelect(getSelect()-1);
        drawDeselection(posElement[getLastSelect()][0]-2, posElement[getLastSelect()][1]-1, posElement[getLastSelect()][2]+2, HEIGHTCARACTER+2, lcd);
        drawSelection(posElement[getSelect()][0]-2, posElement[getSelect()][1]-1, posElement[getSelect()][2]+2, HEIGHTCARACTER+2, lcd);
        // transmit work screen to physical screen:
        lcd->Flush();
    }
}

// El botón 4 baja la selección al elemento superior al actual
void Menu::button4pressed(DogMLCD* lcd){
    // Si sales de los elementos seleccionables no se cambia de selección
    if((getSelect()+1) <= (nElementos - 1)){
        setSelect(getSelect()+1);
        drawDeselection(posElement[getLastSelect()][0]-2, posElement[getLastSelect()][1]-1, posElement[getLastSelect()][2]+2, HEIGHTCARACTER+2, lcd);
        drawSelection(posElement[getSelect()][0]-2, posElement[getSelect()][1]-1, posElement[getSelect()][2]+2, HEIGHTCARACTER+2, lcd);
        // transmit work screen to physical screen:
        lcd->Flush();
    }
}

// El botón 5 envía a la pantalla correspondiente según el elemento seleccionado
void Menu::button5pressed(DogMLCD* lcd){
    SC.changeScreen(nextScreenID[getSelect()]);
}

// Añade un elemento al menu con el texto especificado en el primer argumento
// cada elemento nos enviará a la pantalla con el identificador del segundo argumento
// Devuelve el identificador del elemento añadido
int Menu::addElement(char text[], char nameNextScreen[NCARSCREEN]){
    strcpy(list[nElementos], text);
    strcpy(nextScreenID[nElementos], nameNextScreen);
    nElementos++;
    return nElementos - 1;
}


// Devuelve el ancho del elemento
// Para ello lo recorre sumando los pixeles que ocupa cada caracter
int Menu::widthElement(int element, DogMLCD* lcd){
    int width = 0;
    for(int i = 0; i < (strlen(list[element])); i++){
        width += lcd->GetGlyph(list[element][i]).wid + 1;
    }
    return width;
}

