#include "NuevoViaje.h"
/// ACELEROMETRO DIGITAL///
//KXR94 kionix(p11,p12,p13,p21);

extern KXR94 kionix;

extern ScreenManager SC;
extern SistemaArchivos SA;
extern Configuracion config;
extern MSCFileSystem msc;
extern FechaHora FH;

extern DigitalOut myled;
extern DigitalOut myled4;

extern DigitalIn boton5;
extern DigitalIn boton6;

extern AccelRAM *mRAM;

extern Timer t; // Temporizador usado para controlar la animación de la pantalla

NuevoViaje::NuevoViaje(char newtitle[], char newsubtitle[], char newmsg11[], char newmsg12[], char newmsg2[]){
    strcpy(title, newtitle);
    strcpy(subtitle, newsubtitle);
    strcpy(msg11, newmsg11);
    strcpy(msg12, newmsg12);
    strcpy(msg2, newmsg2);
}  

void NuevoViaje::initialize(DogMLCD* lcd){  

    /* PRUEBA AccelRAM */
    /*SPI spi(p5, p6, p7); //mosi, miso, sclk
    AccelRAM *mRAM = new AccelRAM(spi);
    unsigned int i = 12;
    int16_t envio[3];
    
    for(i = 0; i <= mRAM->getMaxAddressPaquetes(); i++){
        envio[0] = i;
        envio[1] = i+1;
        envio[2] = i+2;
        mRAM->putData(i, envio);
        myled = 1;
    }
    myled = 1;
    // Se leen los caracteres guardados en las memorias y se guardan en un USB
    FILE* fp = fopen("/local/pruebaRAMs.txt","w");
    int16_t recibido[3];
    for(i = 0; i <= mRAM->getMaxAddressPaquetes(); i++){        
        mRAM->readData(i, recibido);
        fprintf(fp, "%d, %d, %d\n", recibido[0], recibido[1], recibido[2]);
    }
    fclose(fp);
    myled = 0;*/
    /* FIN PRUEBA AccelRAM */
    
    // Inicilización de las variables
    aXanterior = 0;
    aYanterior = 0;
    aZanterior = 0;    
    
    ContadorDatos = 0;
    pulsado5 = false;
    pulsado6 = false;
    leyendoDatos = false;
    PasoTiempo = 1.0e6/config.getVelocidadAdquisicion();
    
    // select font to use:
    lcd->XFont = xfont_11;

    // output title text
    lcd->XString( OFFSETX, OFFSETY, title);
    
    lcd->XFont = xfont_8;
    
    // output subtitle text
    char aux[MAXCAR*2];
    char aux2[MAXCAR];
    strcpy(aux, subtitle);
    config.getVelocidadAdquisicionString(aux2);
    strcat(aux, aux2);
    strcat(aux, " Hz");
    lcd->XString( OFFSETX, OFFSETY + 11, aux);
    
    // output msg2 text
    lcd->XString( OFFSETX, HEIGHT -1 - 8, msg2);
    
    // Se pinta el recuadro del gráfico animado
    lcd->Frame(POSX0, POSY0, POSX0 + WIDTHFRAME, POSY0 + HEIGHTFRAME);
    
    // Se pinta el recuadro lleno que se moverá dentro dle recuadro pintado anteriormente
    lcd->Rect(POSX0 + 1, POSY0 + 1, POSX0 + 1 + WIDTHRECT, POSY0 + HEIGHTFRAME);
    
    // Se inicializa el sentido de la animación (sentido en el que se mueve incialmente el recuadro
    posXF = POSX0 + 1 + WIDTHRECT;
    sentidoAnimacion = true;

    // transmit work screen to physical screen:
    lcd->Flush(); 
    
    // se actualiza la fecha
    FH.update();
    
    // El archivo donde se guardarán los datos es la fecha y hora con formato con la extensión .txt
    char fileName[64];
    char auxTime[64];
    
    strcpy(auxTime, FH.getFechaHora());
    strcpy(fileName, "/usb/RAW");
    strcat(fileName, auxTime);
    strcat(fileName, ".txt");    
    
    // Se prepara el USB para escribir en él
    // Si el USB está desconectado se avisa del error
    if(msc.disk_initialize()){
        SC.changeScreen("USBdesconectado");
    }    
    
    // Se inicia el contador para comprobar si el USB se ha quedado colgado y se activa el ticker que cumple esta función
    //t.start();
    // Cada segundo se comprueba si el USB se ha quedado colgado (o no está conectado)
    //USBcolgado.attach(this, &NuevoViaje::compruebaUSB, 1);
     
    fp = fopen(fileName, "w");
    if(fp == NULL){     // Si el USB está desconectado o lleno se avisa por pantalla y se vuelve al menú
        // Se desactiva y reseta el timer
        /*t.stop();
        t.reset();
        USBcolgado.detach();*/
        SC.changeScreen("USBdesconectado");
    }else{  // Si no se prepara el acelerómetro para comenzar con las lecturas    
        // Se cargan los valores de calibración del acelerómetro
        ParametrosCalibracion::leerValores(valoresCal);
        
        /*FILE* fp = fopen("/local/prueba2.txt","w");
        fprintf(fp, "%f\n%f\n%f\n%f\n%f\n%f\n", valoresCal[0], valoresCal[1], valoresCal[2], valoresCal[3], valoresCal[4], valoresCal[5]);
        fclose(fp);*/
        
        // Se crean los buffer donde se guardarán los datos        
        buff_aX = new Buffering();
        buff_aY = new Buffering();
        buff_aZ = new Buffering();
        
        kionix.AcelerometroWakeUp();
        // Hasta que no está preparado no se muestra el mensaje de "OK para comenzar"
        // output msg11 text
        // select font to use:
        lcd->XFont = xfont_11;
        lcd->XString(OFFSETX, HEIGHT -1 - 8 - 11, msg11);  // Se pinta más arriba para que haya más espacio
        
        // transmit work screen to physical screen:
        lcd->Flush();        
    }
    
    // Debug
    //llamadasTicker = 0;
}
    
void NuevoViaje::update(DogMLCD* lcd){    
    // ANIMACIÓN
    // Si se están leyendo datos
    if(leyendoDatos){
        if(t.read_ms() >= UPDATETIME){           
            // Se procede de forma distinta según el sentido de movimiento del recuadro
            if(sentidoAnimacion){       // Derecha       
                // Se pinta la siguiente columna del recuadro
                lcd->LineV(posXF + 1, POSY0 + 1, POSY0 + HEIGHTFRAME-1);
                
                // Se borra la correspondiente para que el recuadro siga teniendo el mismo tamaño
                lcd->LineV(posXF - WIDTHRECT, POSY0 + 1, POSY0 + HEIGHTFRAME-1, wipe);        
                posXF++;
                
                // Si se ha llegado al final del frame, se cambia de sentido y se sitúa la variable posXF en la izquierda del recuadro animado
                if(posXF >= POSX0 + WIDTHFRAME - 1){
                    sentidoAnimacion = false;
                    posXF = POSX0 + WIDTHFRAME - WIDTHRECT;
                }
            }else{                      // Izquierda
                // Se pinta la siguiente columna del recuadro
                lcd->LineV(posXF - 1, POSY0 + 1, POSY0 + HEIGHTFRAME-1);
                
                // Se borra la correspondiente para que el recuadro siga teniendo el mismo tamaño
                lcd->LineV(posXF + WIDTHRECT - 1, POSY0 + 1, POSY0 + HEIGHTFRAME-1, wipe);
                posXF--;
                
                // Si se ha llegado al final del frame, se cambia de sentido y se sitúa la variable posXF en la derecha del recudro animado
                if(posXF <= POSX0 + 2){
                    sentidoAnimacion = true;
                    posXF = POSX0 + 1 + WIDTHRECT;
                }
            }
            
            // Se envía a la pantalla la actualización(tener cuidado con las páginas que se envían)
            lcd->Flush(3, 0, posXF+WIDTHRECT+1);
            lcd->Flush(4, 0, posXF+WIDTHRECT+1);
            
            // Se resetea el contador
            t.reset();     
        }
    }
    
    if(boton5 == 1){
        pulsado5 = true;
    }else{
        if(pulsado5 == true){   // El boton ha sido pulsado
            pulsado5 = false;            
            if(!leyendoDatos){      // Si el viaje no habia comenzado
                // Primero hay que comprobar si el USB está desconectado
                leyendoDatos = true;
                // Se inicia el timer que controlará el temporizador
                t.reset();
                t.start();
                
                // Debug
                /*time.reset();
                time.start();*/
                
                // Se comienza a leer el acelerómetro
                tickerLectura.attach_us(this, &NuevoViaje::LeeAcelerometroBuffer, PasoTiempo);
                // Se cambia el mensaje 11 por el 12
                // para ello se pinta un rectángulo vacío en la posición de los caracteres anteriores y se pinta encima los nuevos caracteres
                int y0 = HEIGHT -1 - 8 - 11;
                for(int i = 0; i < WIDTH; i++){
                    for(int k = y0; k < (y0 + 11); k++){
                        lcd->Wipe(i,k);
                    }
                }
                
                // select font to use:
                lcd->XFont = xfont_11;
                
                // output msg11 text
                lcd->XString( OFFSETX, HEIGHT -1 - 8 - 11, msg12);  // Se pinta más arriba para que haya más espacio
                
                // transmit work screen to physical screen:
                lcd->Flush();           
            }else{  // Si el viaje estaba en curso y se desea finalizar
            
                // Se duerme el acelerómetro                
                kionix.AcelerometroSleep();                
                tickerLectura.detach();
                
                fclose(fp); //cierra fichero con datos en el USB
                // Se deja libre la memoria de los buffer              
                delete buff_aX;
                delete buff_aY;
                delete buff_aZ;
                
                /********************* DEBUG ********************************/
                // Se comprueba que los datos en RAM son los mismos que los guardados en el USB
                myled4 = 1;
                FILE* fp = fopen("/local/pruebaRAMs.txt","w");
                int16_t recibido[3];
                int i;
                float tiempo;     //Tiempo en segundos  
                //fprintf(fp,"%d\n", mRAM->getMaxAddressPaquetes());
                for(i = 0; i <= mRAM->getMaxAddressPaquetes(); i++){        
                //for(i = 0; i <= 100; i++){    
                    mRAM->readData(i, recibido);
                    aXr = recibido[0];
                    aYr = recibido[1];
                    aZr = recibido[2];
                    
                    aX = (-1.0)*((float)aXr-(valoresCal[0]))*valoresCal[3];
                    aY = (-1.0)*((float)aYr-(valoresCal[1]))*valoresCal[4];
                    aZ = (-1.0)*((float)aZr-(valoresCal[2]))*valoresCal[5];
                    // Para evitar algunos fallos por saturación todo valor mayor que 20 se le da el valor del punto anterior
                    if(aX > 20.0){
                      aX = aXanterior;
                    }
                    if(aY > 20.0){
                      aY = aYanterior;
                    }
                    if(aZ > 20.0){
                      aZ = aZanterior;
                    }
                    
                    // También se debe calcular la saturación en 0, por ello si un valor es menor (en valor absoluto)
                    // que la precisión del acelerómetro se le da también el valor del punto anterior
                    if(aX*1000 == 0.0000 ){
                        aX = aXanterior;
                    }
                    if(aY*1000 == 0.0000){
                        aY = aYanterior;
                    }
                    if(aZ*1000 == 0.0000){
                        aZ = aZanterior;
                    }        
                    
                    aXanterior = aX;
                    aYanterior = aY;
                    aZanterior = aZ;  
                
                
                    tiempo = ((float)i)*((float)PasoTiempo)/1.0e6;
                    
                    fprintf(fp,"%f %f %f %f\n", tiempo, aX, aY, aZ);
                }
                fclose(fp);
                myled4 = 0;
                /************************************************************/
                
                // Se para el temporizador
                t.stop();
                
                // Debug
                //time.stop();
                
                // Debug
                /*FILE* fp = fopen("/local/prueba3.txt","w");
                fprintf(fp, "%d, %d", ContadorDatos, llamadasTicker);
                fclose(fp);       */         
                
                // Se pasa a la pantalla de guardado del viaje
                SC.changeScreen("archivoGuardado");                
            }
        }
    }
    
    // Botón atrás
    if(boton6 == 1){
        pulsado6 = true;
    }else{
        if(pulsado6 == true){
            pulsado6 = false;
            // Solo se volverá al menú si el viaje no está en proceso
            if(!leyendoDatos){
                fclose(fp); //cierra fichero con datos en el USB                
                // Se duerme el acelerómetro                
                kionix.AcelerometroSleep();  
                // Se deja libre la memoria de los buffer
                delete buff_aX;
                delete buff_aY;
                delete buff_aZ;
                SC.changeScreen("menu");
            }
            
        }
    }
    // Siempre que existan datos por guardar, se guardan en el USB
    GuardaDatosBuffer();
}

void NuevoViaje::LeeAcelerometroBuffer()
{
    // Debug
    //llamadasTicker++;
    
    kionix.ReadAccels_KXR94(readings);
    
    aaX = (int16_t)readings[0];
    aaY = (int16_t)readings[1];
    aaZ = (int16_t)readings[2];

    buff_aX->put(aaX);   
    buff_aY->put(aaY);
    buff_aZ->put(aaZ);
}      
        
void NuevoViaje::GuardaDatosBuffer()
{
    bool empty = buff_aX->isEmpty();
    
    int dif;          //Diferencia entre writting index y riding index. El buffer se llena cuando esta diferencia alcanza el tamaño del buffer
    float tiempo;     //Tiempo en segundos    
    
    if(empty == false)
    {     
        aXr = buff_aX->get(); 
        aYr = buff_aY->get(); 
        aZr = buff_aZ->get();
        
        // Se guardan los datos en la RAM (si hay espacio)
        if(ContadorDatos <= mRAM->getMaxAddressPaquetes()){
            envioRAM[0] = aXr;
            envioRAM[1] = aYr;
            envioRAM[2] = aZr;
            // Se envían las 3 acelraciones
            mRAM->putData(ContadorDatos, envioRAM);
        }
        
        
        // Debug
        // Usar las líneas de código inferiores para depurar el buffering
        /*int wi = buff_aX->getWritingIndex();
        int ri = buff_aX->getReadingIndex();
        int dif = buff_aX->getDif();*/
        
        aX = (-1.0)*((float)aXr-(valoresCal[0]))*valoresCal[3];
        aY = (-1.0)*((float)aYr-(valoresCal[1]))*valoresCal[4];
        aZ = (-1.0)*((float)aZr-(valoresCal[2]))*valoresCal[5];
        // Para evitar algunos fallos por saturación todo valor mayor que 20 se le da el valor del punto anterior
        if(aX > 20.0){
          aX = aXanterior;
        }
        if(aY > 20.0){
          aY = aYanterior;
        }
        if(aZ > 20.0){
          aZ = aZanterior;
        }
        
        // También se debe calcular la saturación en 0, por ello si un valor es menor (en valor absoluto)
        // que la precisión del acelerómetro se le da también el valor del punto anterior
        if(aX*1000 == 0.0000 ){
            aX = aXanterior;
        }
        if(aY*1000 == 0.0000){
            aY = aYanterior;
        }
        if(aZ*1000 == 0.0000){
            aZ = aZanterior;
        }        
        
        aXanterior = aX;
        aYanterior = aY;
        aZanterior = aZ;  
    
    
        tiempo = ((float)ContadorDatos)*((float)PasoTiempo)/1.0e6;
        ContadorDatos++;
        
        //if(fprintf(fp,"%f %f %f %f\n", tiempo, aXr, aYr, aZr) < 0){   // Pruebas
        if(fprintf(fp,"%f %f %f %f\n", tiempo, aX, aY, aZ) < 0){
        //if(fprintf(fp,"%f\n", tiempo) < 0){    // Pruebas
        //if(fprintf(fp,"%f %f %f %f %d %d %d\n", tiempo, aX, aY, aZ, wi, ri, dif) < 0){    // pruebas
        //if(fprintf(fp,"%d %f %f %f %d %d %d\n", time.read_us(), aX, aY, aZ, wi, ri, dif) < 0){    // pruebas
        //if(fprintf(fp,"%f %f %f %f %d %d %d\n", tiempo, aX, aY, aZ, llamadasTicker, ContadorDatos, llamadasTicker-ContadorDatos) < 0){    // pruebas
            // Si se sigue estando en la pantalla de NuevoViaje se aborta la lectura de datos y se muestra por pantalla que el USB ha sido desconectado
            if(strcmp(SC.getCurrentScreen(), "viaje") == 0){
                
                // Se duerme el acelerómetro                
                kionix.AcelerometroSleep();                
                tickerLectura.detach();
                fclose(fp); //cierra fichero con datos en el USB
                // Se deja libre la memoria de los buffer
                delete buff_aX;
                delete buff_aY;
                delete buff_aZ;
                SC.changeScreen("USBdesconectado");
            }
        }    
        
        // Debug
        // Código para ralentizar la mbed
        /*for(int i = 0; i< 10000000; i++){
            int prueba34 = prueba34*prueba34/17*23425434;
        }*/
    }
}




