/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef MULTIPLERAM_H
#define MULTIPLERAM_H

#include "mbed.h"
#include "23LCV1024.h"

#define NRAMS   3 // Número de RAMs
#define RAMBYTES 131072 // Capacidad (en bytes) de las cada RAM



// Clase que gestiona el uso de ultiples RAMs como si fueran una sola de mayor tamaño. Si cambia el número e RAMS debe cambiar esta clase.
// Todas las RAMS conectadas al mismo puerto SPI (no se van a utilizar simultáneamente)
// Clase configurada para 3 RAMs actualmente.
class MultipleRAM{
    public:
    MultipleRAM(SPI spi);
    ~MultipleRAM();
    
    int readBytes(int address, char* buffer, int length);
    int writeBytes(int address, char* buffer, int length);
    
    unsigned int getMaxAddress();
    
    private:
    SRAM23LCV1024 *sram[NRAMS];
    SPI _spi;
    
    // Deuelve la memoria total efectiva
    unsigned int maxAddress;
    
    
};

#endif