#include "AutoCalibracion.h"
/// ACELEROMETRO DIGITAL///
extern KXR94 kionix;

extern ScreenManager SC;
extern SistemaArchivos SA;
extern Configuracion config;
extern MSCFileSystem msc;

extern DigitalIn boton5;
extern DigitalIn boton6;

void AutoCalibracion::initialize(DogMLCD* lcd){  
    pasoCalibracion = 0;        // Pantalla de introduccion
    
    mediaXpos = 0;
    mediaYpos = 0;
    mediaZpos = 0;
    mediaXneg = 0;
    mediaYneg = 0;
    mediaZneg = 0;    
    
    // Inicilización de las variables
    pulsado5 = false;
    pulsado6 = false;
    leyendoDatos = false;
    
    char idioma[16];
    // Se selecciona el idioma
    config.getIdioma(idioma);
    
    // select font to use:
    lcd->XFont = xfont_11;

    // output title text
    if(strcmp(idioma, "spanish") == 0){        
        lcd->XString( OFFSETX, OFFSETY, "Autocalibraci\242n");
    }else if(strcmp(idioma, "english") == 0){
        lcd->XString( OFFSETX, OFFSETY, "Autocalibration");
    }
    
    lcd->XFont = xfont_8;
    
    if(strcmp(idioma, "spanish") == 0){        
        lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Siga los pasos siguientes");        
        lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "para calibrar el");
        lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8*2, "dispositivo.");
    }else if(strcmp(idioma, "english") == 0){
        lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Follow next steps to");
        lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "calibrate the device.");
    }        

    // transmit work screen to physical screen:
    lcd->Flush();       
    
    // Se prepara el acelerómetro
    kionix.AcelerometroWakeUp();
    // select font to use:
    lcd->XFont = xfont_11;
    
    // output msg2 text
    if(strcmp(idioma, "spanish") == 0){        
        lcd->XString( OFFSETX, HEIGHT -1 - 18, "OK para continuar.");
    }else if(strcmp(idioma, "english") == 0){
        lcd->XString( OFFSETX, HEIGHT -1 - 18, "OK to continue.");
    }
    
    // transmit work screen to physical screen:
    lcd->Flush();    
}

void AutoCalibracion::update(DogMLCD* lcd){
    // Si se están leyendo datos se comprueba si se ha tomado el número de medidas deseadas
    if(leyendoDatos){       
        if(datosCapturados >= NDATOSPASO){          // Se ha acabado la lectura de los datos      
            // Se para la lectura de datos              
            tickerLectura.detach();
            
            leyendoDatos = false;
            
            // Se guarda el valor de la media en su variable correspondiente
            // Dependiendo del paso nos interesa sumar un eje en concreto
            switch(pasoCalibracion){
                case 1:
                    mediaXpos = mediaAux/NDATOSPASO;
                    //mediaZpos = mediaAux;
                break;
                    
                case 2:
                    mediaXneg = mediaAux/NDATOSPASO;
                    //mediaXneg = mediaAux;
                break;
                
                case 3:
                    mediaYneg = mediaAux/NDATOSPASO;
                    //mediaXpos = mediaAux;
                break;
                    
                case 4:
                    mediaYpos = mediaAux/NDATOSPASO;
                    //mediaYpos = mediaAux;
                break;
                    
                case 5:
                    mediaZpos = mediaAux/NDATOSPASO;
                    //mediaYneg = mediaAux;
                break;
                    
                case 6:
                    mediaZneg = mediaAux/NDATOSPASO;
                    //mediaZneg = mediaAux;
                    
                    // Una vez terminado el paso 6 ya se tienen los datos suficientes para calcular los parámetros de calibración
                    // Primero se calculan los factores de conversión a unidades físicas
                    float newKX;
                    float newKY;
                    float newKZ;
                    if(mediaXpos >= mediaXneg){
                        newKX = (2.0*ACELGRAVEDAD)/(mediaXpos - mediaXneg);
                    }else{
                        newKX = (2.0*ACELGRAVEDAD)/(mediaXneg - mediaXpos);
                    }
                    
                    if(mediaYpos >= mediaYneg){
                        newKY = (2.0*ACELGRAVEDAD)/(mediaYpos - mediaYneg);
                    }else{
                        newKY = (2.0*ACELGRAVEDAD)/(mediaYneg - mediaYpos);
                    }
                    
                    if(mediaZpos >= mediaZneg){
                        newKZ = (2.0*ACELGRAVEDAD)/(mediaZpos - mediaZneg);
                    }else{
                        newKZ = (2.0*ACELGRAVEDAD)/(mediaZneg - mediaZpos);
                    }
                    
                    // Se calcula el offset de cada eje                    
                    float newAX;
                    float newAY;
                    float newAZ;
                    
                    //if(mediaXpos >= mediaXneg){
                        //newAX = mediaXpos - (ACELGRAVEDAD/KX);
                    /*}else{
                        newAX = mediaXneg - (ACELGRAVEDAD/KX);
                    }*/
                    
                    //if(mediaYpos >= mediaYneg){
                        //newAY = mediaYpos - (ACELGRAVEDAD/KY);
                    /*}else{
                        newAY = mediaYneg - (ACELGRAVEDAD/KY);
                    }*/
                    
                    //if(mediaZpos >= mediaZneg){
                        //newAZ = mediaZpos - (ACELGRAVEDAD/KZ);
                    /*}else{
                        newAZ = mediaZneg - (ACELGRAVEDAD/KZ);
                    }*/
                    
                    newAX = (mediaXpos + mediaXneg)/2.0;
                    newAY = (mediaYpos + mediaYneg)/2.0;
                    newAZ = (mediaZpos + mediaZneg)/2.0;
                    
                    float param[] = {newAX, newAY, newAZ, newKX, newKY, newKZ};
                    
                    /*FILE* fp = fopen("/local/prueba1.txt","w");
                    fprintf(fp, "%f\n%f\n\n%f\n%f\n\n%f\n%f\n\n%f\n%f\n%f\n\n%f\n%f\n%f\n", mediaYpos, mediaYneg, mediaXpos, mediaXneg, mediaZneg, mediaZpos, newAX, newAY, newAZ, newKX, newKY, newKZ);
                    fclose(fp);*/
                    
                    // Se guardan los nuevos valores de calibración
                    ParametrosCalibracion::saveValores(param);
                    
                break;
            }
            
            pasoCalibracion++;
            
            // Se pinta la siguiente pantalla
            lcd->Flush();
            
        }
    }
    
    // Botón OK
    if(boton5 == 1){
        pulsado5 = true;
    }else{
        if(pulsado5 == true){   // El boton ha sido pulsado
            pulsado5 = false;            
            if(!leyendoDatos){      // Si el viaje no habia comenzado
                leyendoDatos = true;
                
                // Se borra la pantalla
                lcd->Clear();   
                
                char idioma[16];
                // Se selecciona el idioma
                config.getIdioma(idioma);  
                
                // select font to use:
                lcd->XFont = xfont_11; 
                
                // Algunos mensajes son comunes para todos los pasos
                // output msg2 text
                if(strcmp(idioma, "spanish") == 0){        
                    lcd->XString( OFFSETX, HEIGHT -1 - 18, "OK para continuar.");
                }else if(strcmp(idioma, "english") == 0){
                    lcd->XString( OFFSETX, HEIGHT -1 - 18, "OK to continue.");
                }           
                
                // Dependiendo del paso nos interesa sumar un eje en concreto
                switch(pasoCalibracion){
                    case 0:
                        // Se pasa directamente al Paso 1
                        leyendoDatos = false;
                                                
                        // select font to use:
                        lcd->XFont = xfont_11;
                        
                        // output title text
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY, "Paso 1");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY, "Step 1");
                        }
                        
                        lcd->XFont = xfont_8;
                        
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Coloque la cara derecha del");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "dispositivo sobre una");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8*2, "superficie plana.");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Place the right side of the");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "device on a flat surface.");
                        }           
                        
                        // Se prepara el acelerómetro
                        kionix.AcelerometroWakeUp();                       
                        
                        // Se pinta la siguiente pantalla
                        lcd->Flush();
                        pasoCalibracion++;
                    break;
                        
                    case 1:
                        // Lectura de datos del paso 1, se prepara la pantalla del paso 2
                                                
                        // select font to use:
                        lcd->XFont = xfont_11;
                        
                        // output title text
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY, "Paso 2");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY, "Step 2");
                        }
                        
                        lcd->XFont = xfont_8;
                        
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Coloque la cara izquierda del");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "dispositivo sobre una");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8*2, "superficie plana.");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Place the left side of the");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "device on a flat surface.");
                        }
                        
                        mediaAux = 0;
                        datosCapturados = 0;
                        
                        // Se espera unos segundos antes de comenzar a tomar medidas  para asegurar las vibraciones debidas
                        // a la pulsación del botón no interfieren en las medidas
                        wait(OFFSETTIEMPO);
                        // Se comienza a leer el acelerómetro
                        tickerLectura.attach_us(this, &AutoCalibracion::LeeAcelerometro, USENTREDATOS);           
                                          
                    break;
                        
                    case 2:
                    
                        // Lectura de datos del paso 1, se prepara la pantalla del paso 3
                                                
                        // select font to use:
                        lcd->XFont = xfont_11;
                        
                        // output title text
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY, "Paso 3");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY, "Step 3");
                        }
                        
                        lcd->XFont = xfont_8;
                        
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Coloque la cara superior del");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "dispositivo sobre una");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8*2, "superficie plana.");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Place the top side of the");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "device on a flat surface.");
                        }
                        
                        mediaAux = 0;
                        datosCapturados = 0;
                        
                        // Se espera unos segundos antes de comenzar a tomar medidas  para asegurar las vibraciones debidas
                        // a la pulsación del botón no interfieren en las medidas
                        wait(OFFSETTIEMPO);
                        // Se comienza a leer el acelerómetro
                        tickerLectura.attach_us(this, &AutoCalibracion::LeeAcelerometro, USENTREDATOS);    

                    break;
                        
                    case 3:                    
                    
                        // Lectura de datos del paso 1, se prepara la pantalla del paso 4
                                                
                        // select font to use:
                        lcd->XFont = xfont_11;
                        
                        // output title text
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY, "Paso 4");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY, "Step 4");
                        }
                        
                        lcd->XFont = xfont_8;
                        
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Coloque la cara inferior del");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "dispositivo sobre una");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8*2, "superficie plana.");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Place the bottom side of the");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "device on a flat surface.");
                        }
                        
                        mediaAux = 0;
                        datosCapturados = 0;
                        
                        // Se espera unos segundos antes de comenzar a tomar medidas  para asegurar las vibraciones debidas
                        // a la pulsación del botón no interfieren en las medidas
                        wait(OFFSETTIEMPO);
                        // Se comienza a leer el acelerómetro
                        tickerLectura.attach_us(this, &AutoCalibracion::LeeAcelerometro, USENTREDATOS);    
    
                    break;
                        
                    case 4:
                    
                        // Lectura de datos del paso 1, se prepara la pantalla del paso 5
                                                
                        // select font to use:
                        lcd->XFont = xfont_11;
                        
                        // output title text
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY, "Paso 5");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY, "Step 5");
                        }
                        
                        lcd->XFont = xfont_8;
                        
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Coloque la cara frontal del");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "dispositivo sobre una");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8*2, "superficie plana.");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Place the front side of the");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "device on a flat surface.");
                        }
                        
                        mediaAux = 0;
                        datosCapturados = 0;
                        
                        // Se espera unos segundos antes de comenzar a tomar medidas  para asegurar las vibraciones debidas
                        // a la pulsación del botón no interfieren en las medidas
                        wait(OFFSETTIEMPO);
                        // Se comienza a leer el acelerómetro
                        tickerLectura.attach_us(this, &AutoCalibracion::LeeAcelerometro, USENTREDATOS);    

                    break;
                        
                    case 5:
                    
                        // Lectura de datos del paso 1, se prepara la pantalla del paso 6
                                                
                        // select font to use:
                        lcd->XFont = xfont_11;
                        
                        // output title text
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY, "Paso 6");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY, "Step 6");
                        }
                        
                        lcd->XFont = xfont_8;
                        
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Coloque la cara trasera del");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "dispositivo sobre una");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8*2, "superficie plana.");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG, "Place the rear side of the");
                            lcd->XString( OFFSETX, OFFSETY + OFFSETMSG + 8, "device on a flat surface.");
                        }
                        
                        mediaAux = 0;
                        datosCapturados = 0;
                        
                        // Se espera unos segundos antes de comenzar a tomar medidas  para asegurar las vibraciones debidas
                        // a la pulsación del botón no interfieren en las medidas
                        wait(OFFSETTIEMPO*2);
                        // Se comienza a leer el acelerómetro
                        tickerLectura.attach_us(this, &AutoCalibracion::LeeAcelerometro, USENTREDATOS);    

                    break;
                        
                    case 6:
                        
                        // select font to use:
                        lcd->XFont = xfont_11;
                        
                        // output title text
                        if(strcmp(idioma, "spanish") == 0){        
                            lcd->XString( OFFSETX + 28, OFFSETY + 8, "Calibraci\242n");
                            lcd->XString( OFFSETX + 28, OFFSETY + 8 + 12, "completada.");
                        }else if(strcmp(idioma, "english") == 0){
                            lcd->XString( OFFSETX + 28, OFFSETY + 8, "Calibration");
                            lcd->XString( OFFSETX + 28, OFFSETY + 8 + 12, "completed.");
                        }
                        
                        mediaAux = 0;
                        datosCapturados = 0;
                        
                        // Se espera unos segundos antes de comenzar a tomar medidas  para asegurar las vibraciones debidas
                        // a la pulsación del botón no interfieren en las medidas
                        wait(OFFSETTIEMPO);
                        // Se comienza a leer el acelerómetro
                        tickerLectura.attach_us(this, &AutoCalibracion::LeeAcelerometro, USENTREDATOS);                   

                    break;
                    
                    case 7:
                        // Se duerme el acelerómetro                
                        kionix.AcelerometroSleep();                           
                        // Se vuelve a la pantalla de configuración
                        SC.changeScreen("configuracion");
                    break;
                }
            }
        }
    }

    // Botón atrás
    if(boton6 == 1){
        pulsado6 = true;
    }else{
        if(pulsado6 == true){
            pulsado6 = false;
            // En cualquier momento puede volverse atrás (al menú de configuración) parando el proceso actual y perdiendo todos los datos que se hayan guardado de la calibración hasta el mommento, teniendo que repetir el proceso     
            // Se duerme el acelerómetro                
            kionix.AcelerometroSleep();  
            SC.changeScreen("configuracion");
        }
    }   
}

void AutoCalibracion::LeeAcelerometro()
{
    kionix.ReadAccels_KXR94(readings);
    
    // Dependiendo del paso nos interesa sumar un eje en concreto
    switch(pasoCalibracion){
        case 1:
            mediaAux += readings[0];
        break;
            
        case 2:
            mediaAux += readings[0];
        break;
            
        case 3:
            mediaAux += readings[1];
        break;
            
        case 4:
            mediaAux += readings[1];
        break;
            
        case 5:
            mediaAux += readings[2];
        break;
            
        case 6:
            mediaAux += readings[2];
        break;
    }
        
    datosCapturados++;
} 