/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#include "ArchivoGuardado.h"

extern ScreenManager SC;
extern FechaHora FH;

ArchivoGuardado::ArchivoGuardado(char nextScreen[], char newAdvice[], char newnameTitle[], char newdateTitle[], char newtimeTitle[]){
    strcpy(nextScreenID, nextScreen);
    strcpy(advice, newAdvice);
    
    strcpy(nameTitle, newnameTitle);
    strcpy(dateTitle, newdateTitle);
    strcpy(timeTitle, newtimeTitle);
}

void ArchivoGuardado::button5pressed(DogMLCD* lcd){
    SC.changeScreen(nextScreenID);
}

void ArchivoGuardado::initialize(DogMLCD* lcd){    
    // select font to use:
    lcd->XFont = xfont_8;
    
    // Se escribe el nombre
    lcd->XString(OFFSETXTITLES, OFFSETY, nameTitle);
    
    // NOTA: No se debe llamar a FHupdate() porque sino se actualizaría la hora y lo que queremos mostrar es la hora del último archivo guardado que fue la última vez que se actualizo la hora
    char fileName[64];
    char auxTime[64];    
    strcpy(auxTime, FH.getFechaHora());
    strcpy(fileName, "RAW");
    strcat(fileName, auxTime);
    lcd->XString(OFFSETX - 2, OFFSETY + 8, fileName);   // Cambiar
    
    // Se escribe la fecha
    lcd->XString(OFFSETXTITLES, OFFSETY + 8*2, dateTitle);
    lcd->XString(OFFSETX, OFFSETY + 8*3, FH.getFecha()); // Cambiar
    
    // Se escribe el tiempo
    lcd->XString(OFFSETXTITLES, OFFSETY + 8*4, timeTitle);
    
    char aux[16];
    strcpy(aux, FH.getHora());
    aux[2] = ':';
    aux[5] = ':';
    lcd->XString(OFFSETX, OFFSETY + 8*5, aux); // Cambiar
    
    // Se escribe el consejo en la parte inferior de la pantalla
    lcd->XString(OFFSETX, HEIGHT - 8, advice);
    
    // transmit work screen to physical screen:
    lcd->Flush();
}