/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
 
#include "ScreenManager.h"

ScreenManager::ScreenManager(DogMLCD* lcdScreen){
    currentGroupID = 0;
    currentScreen = 0;
    lastScreen = 0;
    for(int i = 0; i < NIDIOMAS; i++){
        nScreens[i] = 0;
    }
    lcd = lcdScreen;
}

void ScreenManager::selectGroup(int groupID){
    currentGroupID = groupID;
}

int ScreenManager::addScreen(Screen* screen, char name[16], int groupID){   // Devuelve el índice asignado a la nueva pantalla
    screens[groupID][nScreens[groupID]] = screen;
    strcpy(screenName[groupID][nScreens[groupID]],name);
    nScreens[groupID]++;
    return nScreens[groupID] - 1;
}    

void ScreenManager::changeScreen(char nameNextScreen[16]){
    // se busca el identificador numérico de la lista de pantallas según el nombre pasado a la función
    // para ello se recorre la lista de pantallas
    int nextScreen;
    for(int i = 0; i < nScreens[currentGroupID]; i++){
        if(strcmp(nameNextScreen, screenName[currentGroupID][i]) == 0){
            nextScreen = i;
        }
    }
    // Se selecciona la siguiente pantala
    lastScreen = currentScreen;
    currentScreen = nextScreen;
    // Se borra la pantalla para dejar paso a la pantalla siguiente
    lcd->Clear();
    lcd->Flush();
    // Se inicializa la pantalla siguiente
    screens[currentGroupID][currentScreen]->initialize(lcd);
}

char *ScreenManager::getCurrentScreen(){
    return screenName[currentGroupID][currentScreen];
}

int ScreenManager::getnScreen(int groupID){
    return nScreens[groupID];
}

void ScreenManager::getLastScreen(char buff[]){
    strcpy(buff, screenName[currentGroupID][lastScreen]);
}

int ScreenManager::getCurrentGroupID(){
    return currentGroupID;
}

void ScreenManager::backScreen(){
    changeScreen(screenName[currentGroupID][lastScreen]);
}

void ScreenManager::initialize(){
    screens[currentGroupID][currentScreen]->initialize(lcd);
}
    
void ScreenManager::update(){
    screens[currentGroupID][currentScreen]->update(lcd);
}