/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#include "MultipleRAM.h"

MultipleRAM::MultipleRAM(SPI spi) : _spi(spi){
    spi.frequency(16000000);    // Velocidad del puerto SPI
    maxAddress = NRAMS*RAMBYTES - 1;
    
    sram[0] = new SRAM23LCV1024(_spi,p20);
    sram[1] = new SRAM23LCV1024(_spi,p19);
    sram[2] = new SRAM23LCV1024(_spi,p18);
}

int MultipleRAM::readBytes(int address, char* buffer, int length){
    // Se calcula la ram a la que se debe acceder y la dirección de esta
    int index = address/RAMBYTES; // A qué memoria se va a acceder
    int ramAddress = address - RAMBYTES*index;    // Dirección real a la que se accede a la memoria
    return sram[index]->readBytes(ramAddress, buffer, length);
}

int MultipleRAM::writeBytes(int address, char* buffer, int length){
    // Se calcula la ram a la que se debe acceder y la dirección de esta
    int index = address/RAMBYTES; // A qué memoria se va a acceder
    int ramAddress = address - RAMBYTES*index;    // Dirección real a la que se accede a la memoria
    return sram[index]->writeBytes(ramAddress, buffer, length);
}

unsigned int MultipleRAM::getMaxAddress(){
    return maxAddress;
}

MultipleRAM::~MultipleRAM() {
    int i;
    for (i = 0; i < NRAMS; i++){        
        delete sram[0];
    }
}
