#include "FechaHora.h"

void FechaHora::update(){
    time(&rawtime);
    timeinfo = localtime(&rawtime);
}

void FechaHora::updateRawTime(){   // Actualiza el número de segundos desde el 1 de enero de 1970
    rawtime = mktime(timeinfo);
    set_time(rawtime);
}

// Funciones que devuelven la fecha y hora como enteros
int FechaHora::getNsecond(){
    return timeinfo->tm_sec;
}

int FechaHora::getNminute(){
    return timeinfo->tm_min;
}

int FechaHora::getNhour(){
    return timeinfo->tm_hour;
}

int FechaHora::getNday(){
    return timeinfo->tm_mday;
}

int FechaHora::getNmonth(){
    return timeinfo->tm_mon + 1;
}

int FechaHora::getNyear(){     // años desde 1900
    return timeinfo->tm_year;
}

// Funciones que configuran la fecha y hora
void FechaHora::setNsecond(int n){
    timeinfo->tm_sec = n;
}

void FechaHora::setNminute(int n){
    timeinfo->tm_min = n;
}

void FechaHora::setNhour(int n){
    timeinfo->tm_hour = n;
}

void FechaHora::setNday(int n){
    timeinfo->tm_mday = n;
}

void FechaHora::setNmonth(int n){
    timeinfo->tm_mon = (n - 1);
}

void FechaHora::setNyear(int n){      // años desde 1900
    timeinfo->tm_year = n;
}

char *FechaHora::getFechaHora(){
    char aux[5];
    memset(fechaHoraFormat,'\0',strlen(fechaHoraFormat));
    
    getDay(aux);    
    strncpy(fechaHoraFormat, aux, 2);
    
    strcat(fechaHoraFormat, "-");
    
    getMonth(aux);
    strncat(fechaHoraFormat, aux, 2);
    
    strcat(fechaHoraFormat, "-");
    
    getYear(aux);
    strncat(fechaHoraFormat, aux, 4);
    
    strcat(fechaHoraFormat, " ");
    
    getHour(aux);
    strncat(fechaHoraFormat, aux, 2);
    
    strcat(fechaHoraFormat, ";");
    
    getMinute(aux);
    strncat(fechaHoraFormat, aux, 2);
    
    strcat(fechaHoraFormat, ";");
    
    getSecond(aux);
    strncat(fechaHoraFormat, aux, 2);
    
    return fechaHoraFormat;
}

char *FechaHora::getFecha(){
    char aux[5];
    memset(fechaHoraFormat,'\0',strlen(fechaHoraFormat));
    
    getDay(aux);    
    strncpy(fechaHoraFormat, aux, 2);
    
    strcat(fechaHoraFormat, "-");
    
    getMonth(aux);
    strncat(fechaHoraFormat, aux, 2);
    
    strcat(fechaHoraFormat, "-");
    
    getYear(aux);
    strncat(fechaHoraFormat, aux, 4);
    
    return fechaHoraFormat;
}

char *FechaHora::getHora(){
    char aux[5];
    memset(fechaHoraFormat,'\0',strlen(fechaHoraFormat));
    
    getHour(aux);
    strncpy(fechaHoraFormat, aux, 2);
    
    strcat(fechaHoraFormat, ";");
    
    getMinute(aux);
    strncat(fechaHoraFormat, aux, 2);
    
    strcat(fechaHoraFormat, ";");
    
    getSecond(aux);
    strncat(fechaHoraFormat, aux, 2);
    
    return fechaHoraFormat;
}


// Funciones que devuelven la hora
void FechaHora::getSecond(char buff[]){
    intTo2char(timeinfo->tm_sec, buff);    
}
void FechaHora::getMinute(char buff[]){
    intTo2char(timeinfo->tm_min, buff); 
}
void FechaHora::getHour(char buff[]){
    intTo2char(timeinfo->tm_hour, buff); 
}

// Funciones que devuelven la fecha
void FechaHora::getDay(char buff[]){
    intTo2char(timeinfo->tm_mday, buff); 
}
void FechaHora::getMonth(char buff[]){
    intTo2char(timeinfo->tm_mon+1, buff); 
}
void FechaHora::getYear(char buff[]){
    int year = 1900 + timeinfo->tm_year;
    intTo4char(year, buff);
}

// La siguiente función devuelve los dos caracteres correspondientes a las dos cifras de un número entre 0 y 99 pasado como argumento (sin signo)
void FechaHora::intTo2char(int value, char buff[]){
    buff[0] = value/10 + '0';   // Decenas
    buff[1] = value - ((int)(value/10))*10 + '0';   // unidades
}

// La siguiente función devuelve los dos caracteres correspondientes a las dos cifras de un número entre 0 y 99 pasado como argumento (sin signo)
void FechaHora::intTo4char(int value, char buff[]){
    buff[0] = value/1000 + '0';   // Millares
    buff[1] = ((int)(value - ((int)(value/1000))*1000))/100 + '0';   // Centenas
    buff[2] = (value - (buff[0] - '0')*1000 - (buff[1] - '0')*100)/10 + '0';
    buff[3] = (value - (buff[0] - '0')*1000 - (buff[1] - '0')*100 - (buff[2] - '0')*10) + '0';    
}