/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef TECLADO_H
#define TECLADO_H

#include "Seleccion.h"
#include "doggy.h"

#define POSCADENAX 3
#define OFFSETX 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres
#define OFFSETY 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres en la parte superior
#define CARACTER11 11     // Anchura de un caracter de media
#define CARACTER8 8     // Anchura de un caracter de media
#define WRITTENSPACE 9    // Pixeles de alto que requiere el espacio donde se irá mostrando lo que se está escribiendo con el teclado
#define MAXCARACTERESESCRITURA 19   // Máximos caracteres que se pueden escribir para el nombre del archivo

#define FILASMATRIZ 5
#define COLUMNASMATRIZ 11


/***************************
    Para controlar la posición del teclado se va a hacer una matriz de 11x5. A cada elemento de la matriz se le asignará un valor (la letra correspondiente)
    y valores especiales las teclas especiales:
    
    0-> espacio vacio
    1-> borrar
    2-> mayus
    3-> barra espaciadora
    4-> Aplicar
    **************************/
#define BACK 1
#define MAYUS 2
#define SPACEBAR 3
#define APLICAR 4
    
#define ULTIMOCARACTERESPECIAL 4        // Se va a usar para comprobar si un elemento de la matrzi es un caracter especial o tecla especial


// Lista de elementos seleccionables. Tamaño de caracteres 8. 
class Teclado: public Seleccion{
    public:
    
    virtual void initialize(DogMLCD* lcd);
    int addElement(char text[], char nameNextScreen[NCARSCREEN]);
    
    char *getNombre();  // Devuelve un puntero al último nombre escrito con el teclado
    
    void setNextScreen(char nameScreen[NCARSCREEN]);
    
    virtual void button1pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón superior es pulsado, definirla para añadir funcionalidades
    virtual void button2pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón superior es pulsado, definirla para añadir funcionalidades
    virtual void button3pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón superior es pulsado, definirla para añadir funcionalidades
    virtual void button4pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón inferior es pulsado, definirla para añadir funcionalidades
    virtual void button5pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón central es pulsado, definirla para añadir funcionalidades
        
    private:
    
    char nameNextScreen[NCARSCREEN];
    
    char m[FILASMATRIZ][COLUMNASMATRIZ];    
    char Xsel, Ysel, lastXsel, lastYsel;          // posición x e y en la matriz del elemento seleccionado y el anterior
    
    char nombre[MAXCARACTERESESCRITURA+1];  // Guarda la cadena con el nombre escrito
    char indiceEscritura;   // Indica por donde se va escribiendo en el recuadro

    void mostrarCaracteres(DogMLCD* lcd);       // Muestra los caracteres de la matriz
    void mostrarEspeciales(DogMLCD* lcd);       // Muestra los caracteres especiales
    void asignarMinusculas();                   // Asigna a la matriz valores de caracteres de las letras minusculas
    void asignarMayusculas();                   // Asigna a la matriz valores de caracteres de las letras minusculas
    
    void mostrarRecuadro(DogMLCD* lcd);         // Muestra el recuadro que señala lo que se está escribiendo
    
    // Cuadros seleccionables especiales
    void seleccionarBarraEspaciadora(DogMLCD* lcd);
    void deseleccionarBarraEspaciadora(DogMLCD* lcd);
    
    void seleccionarAplicar(DogMLCD* lcd);
    void deseleccionarAplicar(DogMLCD* lcd);
    
    bool ifMayus;

};

#endif