/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */ 
#include "Seleccion.h"

extern ScreenManager SC;

extern DigitalIn boton1;
extern DigitalIn boton2;
extern DigitalIn boton3;
extern DigitalIn boton4;
extern DigitalIn boton5;
extern DigitalIn boton6;

Seleccion::Seleccion(){
    // Se inicializan las variables
    invType = true;
    nElementos = 0;
    select = 0;
    lastSelect = 0;
    pulsado1 = false;
    pulsado2 = false;
    pulsado3 = false;
    pulsado4 = false;
    pulsado5 = false;
    pulsado6 = false;
    backScreen = false;
}

void Seleccion::borrarElementos(){
    // para borrar los elementos existentes sólo hay que reiniciar el número de elementos
    nElementos = 0;
}

void Seleccion::setInverterSelection(){
    invType = true;
}

void Seleccion::setRectSelection(){
    invType = false;
}

int Seleccion::getSelect(){
    return select;
}

void Seleccion::setSelect(int newSelect){
    lastSelect = select;
    select = newSelect;
}

int Seleccion::getLastSelect(){
    return lastSelect;
}

bool Seleccion::getSelectType(){
    return invType;
}

void Seleccion::drawSelection(int x, int y, int width, int height, DogMLCD* lcd){
    // Se pinta de distinta manera dependiendo de la forma de selección
    if(invType){
        lcd->InvRect(x, y, x+width, y+height);
    }else{
        lcd->Frame(x, y, x+width, y+height);
    }
}

void Seleccion::drawDeselection(int x, int y, int width, int height, DogMLCD* lcd){
    // Se pinta de distinta manera dependiendo de la forma de selección
    if(invType){
        lcd->InvRect(x, y, x+width, y+height);
    }else{
        lcd->Frame(x, y, x+width, y+height, wipe);
    }
}

// En esta función se comprueba si se han pulsado los botones
void Seleccion::update(DogMLCD* lcd){
    if(boton1 == 1){
        // Se espera a que se suelte el botón
        pulsado1 = true;
    }else{
        if(pulsado1 == true){
            // Antes de cambiar de pantalla se llama la siguiente funcion con la que se puede añadir funcionalidad
            button1pressed(lcd);
            // Se inicializa la variable que controla la pulsación
            pulsado1 = false;
        }
    }
    if(boton2 == 1){
        // Se espera a que se suelte el botón
        pulsado2 = true;
    }else{
        if(pulsado2 == true){
            // Antes de cambiar de pantalla se llama la siguiente funcion con la que se puede añadir funcionalidad
            button2pressed(lcd);
            // Se inicializa la variable que controla la pulsación
            pulsado2 = false;
        }
    }
    if(boton3 == 1){
        // Se espera a que se suelte el botón
        pulsado3 = true;
    }else{
        if(pulsado3 == true){
            // Antes de cambiar de pantalla se llama la siguiente funcion con la que se puede añadir funcionalidad
            button3pressed(lcd);
            // Se inicializa la variable que controla la pulsación
            pulsado3 = false;
        }
    }
    if(boton4 == 1){
        // Se espera a que se suelte el botón
        pulsado4 = true;
    }else{
        if(pulsado4 == true){
            // Antes de cambiar de pantalla se llama la siguiente funcion con la que se puede añadir funcionalidad
            button4pressed(lcd);
            // Se inicializa la variable que controla la pulsación
            pulsado4 = false;
        }
    }
    if(boton5 == 1){
        // Se espera a que se suelte el botón
        pulsado5 = true;
    }else{
        if(pulsado5 == true){
            // Antes de cambiar de pantalla se llama la siguiente funcion con la que se puede añadir funcionalidad
            button5pressed(lcd);
            // Se inicializa la variable que controla la pulsación
            pulsado5 = false;
        }
    }
    if(boton6 == 1){
        // Se espera a que se suelte el botón
        pulsado6 = true;
    }else{
        if(pulsado6 == true){
            // Antes de cambiar de pantalla se llama la siguiente funcion con la que se puede añadir funcionalidad
            button6pressed(lcd);
            // Se inicializa la variable que controla la pulsación
            pulsado6 = false;
        }
    }
}

// Esta función guarda la pantalla a la que se debe volver en caso de ser pulsado el boton atras
void Seleccion::setBackScreen(char nameScreen[NCARSCREEN]){
    strcpy(nameBackScreen, nameScreen);
    backScreen = true;
}

// Esta función desactiva volver a la pantalla anterior (si la pantalla no vuelve a ninguna pantalla debe usarse)
void Seleccion::disableBackScreen(){
    backScreen = false;
}

void Seleccion::button1pressed(DogMLCD* lcd){}
void Seleccion::button2pressed(DogMLCD* lcd){}
void Seleccion::button3pressed(DogMLCD* lcd){}
void Seleccion::button4pressed(DogMLCD* lcd){}
void Seleccion::button5pressed(DogMLCD* lcd){}
void Seleccion::button6pressed(DogMLCD* lcd){
    if(backScreen){
        SC.changeScreen(nameBackScreen);
    }
}