/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef FECHAHORACONF_H
#define FECHAHORACONF_H

#include "Seleccion.h"
#include "FechaHora.h"
#include "doggy.h"

#define NELEMENTS 6          // Número de elementos seleccionables de esta pantalla

#define MAXCARACTER 22      // Número máximo de caracteres de cada elemento
#define OFFSETX 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres
#define OFFSETXTITLES 16            // Espacio en pixeles que se deja antes de escribir una linea de caracteres
#define OFFSETY 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres

#define ANCHOSELECCION2 16  // Ancho del recuadro de selección de dos caracteres
#define ANCHOSELECCION4 32  // Ancho del recuadro de selección de cuatro caracteres
#define ALTOSELECCION 9    // Alto del recuadro de selección

// Lista de elementos seleccionables. Tamaño de caracteres 8. 
class FechaHoraConf: public Seleccion{
    public:
    FechaHoraConf(char newAdvice[], char newAdvice2[], char newAdvice3[], char newdateTitle[], char newtimeTitle[]);
    virtual void initialize(DogMLCD* lcd);
    virtual void update(DogMLCD* lcd);
    
    virtual void button1pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón superior es pulsado, definirla para añadir funcionalidades
    virtual void button2pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón superior es pulsado, definirla para añadir funcionalidades
    virtual void button3pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón superior es pulsado, definirla para añadir funcionalidades
    virtual void button4pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón inferior es pulsado, definirla para añadir funcionalidades
    virtual void button5pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón central es pulsado, definirla para añadir funcionalidades
    
    int addElement(char text[], char posX, char posY);                 // Añade un elemento seleccionable a la pantalla
    void changeElementText(char newText[], int nElemento, DogMLCD* lcd);
    
    private:    
    
    char element[NELEMENTS][5];     // Variable que guarda los elementos seleccionables de la pantalla
    char elementPos[NELEMENTS][2];  // Guarda la posición de los elementos de la pantalla
    
    char advice[MAXCARACTER*3];
    char advice2[MAXCARACTER*2];
    char advice3[MAXCARACTER*2];
    char dateTitle[MAXCARACTER];
    char timeTitle[MAXCARACTER];
    
    void dibujarSeleccion(char nElemento, DogMLCD* lcd);
    void borrarSeleccion(char nElemento, DogMLCD* lcd);
    

};

#endif