/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */

#include "KXR94.h"

KXR94::KXR94(PinName mosi, PinName miso, PinName sck, PinName cs) : spi_(mosi, miso, sck), nCS_(cs) 
{
    // Se configura el puerto SPI
    spi_.frequency(4000000);        // El máximo según el datasheet es 5MHz
    spi_.format(8,0);
        
    // Se prepara el acelerómetro para comenzar las lecturas
    AcelerometroWakeUp();   
}

void KXR94::ReadAccels_KXR94(int* Acc) {
    char x_lsb, x_msb;
    char y_lsb, y_msb;
    char z_lsb, z_msb;
    signed short ax, ay, az;   

    //------------X----------------    
    nCS_ = 0;
    spi_.write(CONVERTX);
    wait_us(40);
    x_msb = spi_.write(0x00);   // Dummy byte
    x_lsb = spi_.write(0x00);   // Dummy byte
    nCS_ = 1;
    wait_us(1);   
    ax = (x_msb << 8) |  x_lsb ;   // combineer msb en lsb
    ax = ax >> 4;                  // Get rid of four non-value bits in LSB
    ax &=~0xF000;
    //------------Y----------------
    nCS_ = 0;
    spi_.write(CONVERTY);
    wait_us(40);
    y_msb = spi_.write(0x00);   // Dummy byte
    y_lsb = spi_.write(0x00);   // Dummy byte
    nCS_ = 1;
    wait_us(1);  
    ay = (y_msb << 8) | y_lsb;     // combineer msb en lsb
    ay = ay >> 4;                  // Get rid of four non-value bits in LSB
    ay &=~0xF000;
    //------------Z----------------
    nCS_ = 0;
    spi_.write(CONVERTZ);
    wait_us(40);
    z_msb = spi_.write(0x00);   // Dummy byte
    z_lsb = spi_.write(0x00);   // Dummy byte
    nCS_ = 1;
    wait_us(1);  
    az = (z_msb << 8) |  z_lsb;    //  combineer msb en lsb
    az = az >> 4;                  // Get rid of four non-value bits in LSB    
    az &=~0xF000;

    Acc[0] = ax;
    Acc[1] = ay;
    Acc[2] = az;
}

//-----------------READ OUT the X-Y-Z values---------------
char KXR94::read_reg() {
    char byte;
    nCS_ = 0;
    spi_.write(READREG);
    byte = spi_.write(0x00);   // Dummy byte
    nCS_ = 1;
    wait_us(1);
    return byte;
}

void KXR94::AcelerometroSleep(void)
{
    nCS_ = 0;
    spi_.write(WRITEREG);
    spi_.write(0x00);   // Enable = 0
    nCS_ = 1;
    wait_us(1);
}  
void KXR94::AcelerometroWakeUp(void)
{
    nCS_ = 0;
    spi_.write(WRITEREG);
    spi_.write(0x04);   // Enable = 1
    nCS_ = 1;
    wait_us(1);
}