#include "ParametrosCalibracion.h"

extern ScreenManager SC;
extern SelecManager SM;


void ParametrosCalibracion::leerValores(float* valores){    // Esta función guarda en un array de 6 float los valores de calibración
    // Se lee el archivo de valores de calibracion
    FILE* file;    
    if((file = fopen("/local/Calibrat.vme","rb")) == NULL){  // Si no existe 
        // Se crea un fichero con valores por defecto
        createDefaults();
        // Se devuelven los valores por defecto
        valores[0] = AX;      
        valores[1] = AY;
        valores[2] = AZ;
        valores[3] = KX;
        valores[4] = KY;
        valores[5] = KZ;
    }else{  // El archivo ya existe
        // Se leen los 6 valores y se guardan en la dirección pasada como argumento
        fread(valores, 4, 6, file);
    }
    // Se cierra el fichero
    if(file != NULL){
        fclose(file);
    }
}

void ParametrosCalibracion::createDefaults(){    // Esta función guarda en un array de 6 float los valores de calibración
    // Se cre un archivo con los valores por defecto de calibración
    FILE* file;    
    file = fopen("/local/Calibrat.vme","wb");
    
    // datos a aguradar en el fichero
    float datos[] = {AX, AY, AZ, KX, KY, KZ};
    
    // Tamaño de los datos: 32 bits (4 bytes), número de datos : 6    
    fwrite(datos, 4, 6, file);
    
    // Se cierra el fichero    
    fclose(file);
}
    
// Guarda 6 nuevos valores de calibración 
void ParametrosCalibracion::saveValores(float valores[]){    // Esta función guarda en un array de 6 float los valores de calibración
    // Se cre un archivo con los valores por defecto de calibración
    FILE* file;    
    file = fopen("/local/Calibrat.vme","wb");
    
    // Tamaño de los datos: 32 bits (4 bytes), número de datos: 6    
    fwrite(valores, 4, 6, file);
    
    // Se cierra el fichero    
    fclose(file);
}