#include "Configuracion.h"

extern ScreenManager SC;
extern SelecManager SM;

Configuracion::Configuracion(){
    // Se lee el archivo de configuración, en caso de no existir se crea
    FILE* file;    
    if((file = fopen("/local/Config.vme","r")) == NULL){
        setDefaults();
        createFile();        
    }else{  // El archivo ya existe
        getParam(file, "adquisitionvelocity", velocidadAdquisicion);
        getParam(file, "languaje", idioma);
        getParam(file, "selectiontype", formaSeleccion);       
    }
    // Se cierra el fichero
    if(file != NULL){
        fclose(file);
    }
}

void Configuracion::restoreSettings(){
    setDefaults();
    createFile();
}

void Configuracion::setDefaults(){
    strcpy(velocidadAdquisicion, "1000");
    strcpy(idioma, "spanish");
    strcpy(formaSeleccion, "shading");
    
    // Además del fichero de configuración se cambia la configuración actual de la interfaz
    char aux[16];
    // Se selecciona el idioma
    getIdioma(aux);
    if(strcmp(aux, "spanish") == 0){        
        SC.selectGroup(0);
    }else if(strcmp(aux, "english") == 0){
        SC.selectGroup(1);
    }
    // Se selecciona el modo de selección
    getFormaSeleccion(aux);
    if(strcmp(aux, "shading") == 0){        
        SM.setInverterSelection();
    }else if(strcmp(aux, "framing") == 0){
        SM.setRectSelection();
    }
}

// Esta función busca el valor del parámetro nameParam y lo guarda en buf
// Para ello se recorrera cada una de las lineas del archivo de configuración hasta encontrarlo y leer su valor
// Recordar: El archivo de configuración tiene le siguiente formato
// nombreParámetro valorParámetro
void Configuracion::getParam(FILE* file, char nameParam[], char buf[]){
    // se calcula la longitud del nombre del parámetro
    int lenParam = strlen(nameParam);
    char aux[NCARACTERESLECTURA];
    bool encontrado = false;
    while(!encontrado && (!feof(file))){ // Solo se para de leer si se ha llegado al fin de fichero o se ha encontrado el valor del parámetro
        // Se lee una linea
        fgets(aux, NCARACTERESLECTURA, file);
        if(strncmp(nameParam, aux, lenParam)== 0){
            // Se ha encontrado la línea del parámetro que está guardada en aux
            // se guarda el valor del parámetro (que empieza después de un espacio desde el nombre del parámetro y acaba antes del salto de línea)
            // Antes se calcula cuantos caracteres tiene el valor del parámetro
            // que será la longitud de la línea menos a longitud del nombre del parámetro - 2 (un caracter que es el espacio y el caracter final \n que tampoco debe copiarse
            for(int i = 0; i < strlen(aux) - lenParam - 2; i++){
                buf[i] = aux[i + lenParam + 1]; // +1 porque se empieza a guardar a partir del espacio entre el nombre y el valor
            }            
            encontrado = true;
        }
    }        
}

void Configuracion::createFile(){
    FILE* file = fopen("/local/Config.vme","w");
    fprintf(file, "adquisitionvelocity %s\n", velocidadAdquisicion);
    fprintf(file, "languaje %s\n", idioma);
    fprintf(file, "selectiontype %s\n", formaSeleccion);
    fclose(file);
}

void Configuracion::setVelocidadAdquision(int nuevaVelocidadAdqusicion){
    sprintf(velocidadAdquisicion,"%d",nuevaVelocidadAdqusicion);
    createFile();
}
void Configuracion::setIdioma(char nuevoIdioma[]){
    strcpy(idioma, nuevoIdioma);
    createFile();
}
void Configuracion::setFormaSeleccion(char nuevaFormaSeleccion[]){
    strcpy(formaSeleccion, nuevaFormaSeleccion);
    createFile();
}

int Configuracion::getVelocidadAdquisicion(){
    return atoi(velocidadAdquisicion);
}

void Configuracion::getVelocidadAdquisicionString(char buff[]){
    strcpy(buff, velocidadAdquisicion);
}

void Configuracion::getIdioma(char buf[]){
    strcpy(buf, idioma);
}

void Configuracion::getFormaSeleccion(char buf[]){
    strcpy(buf, formaSeleccion);
}