/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef FECHAHORA_H
#define FECHAHORA_H

#include "mbed.h"
#include <time.h>
#include <string.h> 

// Clase que controla la fecha y la hora del dispositivo
class FechaHora{
    public:
    
    // LLamar esta función para antes de llamar las funciones que devuelven la fecha y hora para actualizarlas internamente
    void update();
    
    void updateRawTime();   // Actualiza el número de segundos desde el 1 de enero de 1970
    
    //Esta función devuelve la fecha y la hora con le siguiente formato: XX-XX-XX XX;XX;XX
    char *getFechaHora();
    
    // Estas dos funciones devuelven la fecha o la hora individualmente
    char *getFecha();
    char *getHora();
    
    // Funciones que devuelven la hora como caracteres
    void getSecond(char buff[]);
    void getMinute(char buff[]);
    void getHour(char buff[]);
    
    // Funciones que devuelven la fecha como caracteres
    void getDay(char buff[]);
    void getMonth(char buff[]);
    void getYear(char buff[]);
    
    // Funciones que devuelven la fecha y hora como enteros
    int getNsecond();
    int getNminute();
    int getNhour();
    
    int getNday();
    int getNmonth();
    int getNyear();      // años desde 1900
    
    // Funciones que configuran la fecha y hora
    void setNsecond(int n);
    void setNminute(int n);
    void setNhour(int n);
    
    void setNday(int n);
    void setNmonth(int n);
    void setNyear(int n);      // años desde 1900
    
    private:
    char fechaHoraFormat[32];
    time_t rawtime;
    struct tm * timeinfo;
    
    // La siguiente función devuelve los dos caracteres correspondientes a las dos cifras de un número entre 0 y 99 pasado como argumento (sin signo)
    void intTo2char(int value, char buff[]);
    
    // La siguiente función devuelve los cuatro caracteres correspondientes a las dos cifras de un número entre 0 y 9999 pasado como argumento (sin signo)
    void intTo4char(int value, char buff[]);
    
};


#endif