/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef SELECCION_H
#define SELECCION_H

#include "ScreenManager.h"
#include "doggy.h"

// Esta clase es la base de pantallas en las que haya objetos sleccionables
// como menus o listas
class Seleccion: public Screen { 

 public:
    int nElementos;     // Número de elementos en la lista de selección
    
    void borrarElementos();     // Borra los elementos existentes
    
    Seleccion();
    
    virtual void update(DogMLCD* lcd);
    
    void setInverterSelection();
    
    void setRectSelection();
    
    int getSelect();
    
    void setSelect(int newSelect);  // Se selecciona un elemento
    
    int getLastSelect();
    
    bool getSelectType();
    
    void drawSelection(int x, int y, int width, int height, DogMLCD* lcd);
    
    void drawDeselection(int x, int y, int width, int height, DogMLCD* lcd);
    
    virtual void button1pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón superior es pulsado, definirla para añadir funcionalidades
    virtual void button2pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón izquierdo es pulsado, definirla para añadir funcionalidades
    virtual void button3pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón derecho es pulsado, definirla para añadir funcionalidades
    virtual void button4pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón inferior es pulsado, definirla para añadir funcionalidades
    virtual void button5pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón central es pulsado, definirla para añadir funcionalidades
    virtual void button6pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón atras es pulsado, definirla para añadir funcionalidades
    char nameBackScreen[NCARSCREEN];
    bool backScreen;        // true si existe pagina atras, sino no se puede volver a la página anterior pulsando el boton correspondiente
    void setBackScreen(char nameScreen[NCARSCREEN]);
    void disableBackScreen();
    
    private:
    int select;         // Elemento seleccionado de la lista de elementos
    int lastSelect;     // Anterior elemento seleccionado
    bool invType;       // Indica el tipo de selección. true: invirtiendo, false: pintando un recuadro
            
    bool pulsado1;
    bool pulsado2;
    bool pulsado3;
    bool pulsado4;
    bool pulsado5;
    bool pulsado6;
};

#endif