/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef SELECMANAGER_H
#define SELECMANAGER_H

#define NSELECSCREEN 25   // Número máximo de pantallas seleccionables

#include "Seleccion.h"

// Esta clase se encarga de gestionar los elementos comunes de las pantallas con elementos seleecionables como por ejemplo la forma de selección
class SelecManager {

public:
    /**
     * Constructor.
     *
     */
    SelecManager();
    
    int addScreen(Seleccion* screen);   // Devuelve el número de identificación en la lista de pantallas seleccionables
    
    void setInverterSelection();      // Configura la forma de selección de inversión de pixeles del elemento
    
    void setRectSelection();         // Configura la forma de selección mediante rectángulos delimitadores  
    
    int getnScreens();
    
private:
    int nScreens;
    Seleccion* screens[NSELECSCREEN];  // Lista de pantallas seleccionables
};

#endif