/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef LISTASELEC_H
#define LISTASELEC_H

#include "Seleccion.h"
#include "doggy.h"

#define OFFSETX 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres
#define OFFSETY 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres en la parte superior
#define MAXCARACTER8 19      // Número máximo de caracteres de cada elemento
#define HEIGHTCARACTER8 8     // Anchura de un caracter de media
#define SCREENLINES 7             // Número máximo de filas mostrados simultáneamente en pantalla
#define MAXLINES8 100            // Número máximo de filas (cada fila es un elemento)

// Lista de elementos seleccionables. Tamaño de caracteres 8. 
class ListaSelec: public Seleccion{
    public:
    
    virtual void initialize(DogMLCD* lcd);
    int addElement(char text[], char nameNextScreen[NCARSCREEN]);
    char *getElement(int index);
    
    void DrawElements(DogMLCD* lcd);    // Pinta a partir del elemento superior, todos los que sea posible hasta ocupar la pantalla (valor de elementos dado por SCREENLINES)
    
    virtual void button1pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón superior es pulsado, definirla para añadir funcionalidades
    virtual void button4pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón inferior es pulsado, definirla para añadir funcionalidades
    virtual void button5pressed(DogMLCD* lcd);     // Esta función se llama cuando el botón central es pulsado, definirla para añadir funcionalidades
        
    private:
    //char list[MAXLINES8][MAXCARACTER8];      // Lista con las opciones seleccionables
    char *list[MAXLINES8];      // Lista con las opciones seleccionables
    char *nextScreenID[MAXLINES8];               // Guarda el nombre de las pantallas a la que debe dirigirse si se elige un elemento
    //char nextScreenID[MAXLINES8][NCARSCREEN];               // Guarda el nombre de las pantallas a la que debe dirigirse si se elige un elemento
    int topElement;
    int posMark;                                // Posicion del marcador de seleccion
    int lastPosMark;                             // Últim posición del marcador de seleccion
};

#endif