/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 * Pantalla de nuevo viaje. En esta se leeran los datos del acelerómetro y se guardarán en memoria, si es necesario utilizando buffering
 * Mientras se elle también se mostrará una pequeña animación para que de la sensación de que el dispositivo está leyendo datos
 */
#ifndef NUEVOVIAJE_H
#define NUEVOVIAJE_H

#include "mbed.h"
#include "SistemaArchivos.h"
#include "ScreenManager.h"
#include "MSCFileSystem.h"
#include "Configuracion.h"
#include "FechaHora.h"
#include "KXR94.h"
#include "Buffering.h"
#include <stdlib.h>
#include "ParametrosCalibracion.h"

#define TUSBCOLGADO 2 // tiempo en segundos que se espera a que responda el USB, en caso contrario se considera que se ha quedado colgado

#define MAXCAR 32
#define OFFSETX 4            // Espacio en pixeles que se deja antes de escribir una linea de caracteres
#define OFFSETY 2            // Espacio en pixeles que se deja antes de escribir una linea de caracteres en la parte superior
//#define SIZEBUFF 250            // Tamaño del buffer de datos

#define COUNTPRECISION 0.00958  // Precisión del dispositivo (mínimo valor de cambio teórico, se calcula como: 4*g/2^12)

// Definiciones gráfico animado
#define POSX0 13
#define WIDTHFRAME 100
#define POSY0 23
#define HEIGHTFRAME 17

#define WIDTHRECT 10    // Ancho del recuadro interior que se mueve a medida que se gravan los datos, el alto del recuadro es el máximo que cabe dentro del frame (8 pixeles, el alto de una página)
#define UPDATETIME 15  // Tiempo en ms que tarda en avanzar una columna el recuadro del gráfico animado

class NuevoViaje : public Screen {
    public:
        NuevoViaje(char newtitle[], char newsubtitle[], char newmsg11[], char newmsg12[], char newmsg2[]);
        virtual void initialize(DogMLCD* lcd);
        virtual void update(DogMLCD* lcd);
    
    private:    
        char title[MAXCAR];
        char subtitle[MAXCAR];
        char msg11[MAXCAR];
        char msg12[MAXCAR];
        char msg2[MAXCAR];
        bool pulsado5;
        bool pulsado6;
        bool leyendoDatos;      // Indica si el viaje está o no en proceso
        unsigned int PasoTiempo;    // Guarda el tiempo en microsegundos que debe de pasar entre cada lectura
        
        Buffering *buff_aX;
        Buffering *buff_aZ;
        Buffering *buff_aY;
        
        FILE * fp;     // Puntero al fichero donde se escribirán los datos
        
        float valoresCal[6];        // Valores de calibración del acelerómetro
        int readings[3];            //Lectura aceleraciones sensor digital
        float aX, aY, aZ;            //Medidas de aceleracion
        float aXanterior, aYanterior, aZanterior;            //Medidas de aceleracion del punto anterior
        int16_t aaX, aaY, aaZ;       //Medidas de aceleracion y tiempo 
        
        float aXr, aYr, aZr;            // Tiempo y medidas de aceleracion leidos del buffer
        unsigned int ContadorDatos;
        
        Ticker tickerLectura;
        void LeeAcelerometroBuffer();
        void GuardaDatosBuffer();
        
        bool sentidoAnimacion;  // Sentido del movimiento del recuadro de la animación (true: derecha, false: izquierda)
        char posXF;             // Guarda la posición de la última columna del recuadro de la animación que ha sido pintado
        
        // Debug
        /*unsigned int llamadasTicker;
        Timer time;*/
};

#endif